/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.coql.BodyWrapper;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.fields.Fields;
import com.zoho.crm.api.fields.FieldsOperations;
import com.zoho.crm.api.fields.LinkingDetails;
import com.zoho.crm.api.fields.LinkingModule;
import com.zoho.crm.api.fields.Multiselectlookup;
import com.zoho.crm.api.modules.APIException;
import com.zoho.crm.api.modules.MinifiedModule;
import com.zoho.crm.api.modules.Modules;
import com.zoho.crm.api.modules.ModulesOperations;
import com.zoho.crm.api.org.Org;
import com.zoho.crm.api.org.ResponseHandler;
import com.zoho.crm.api.org.ResponseWrapper;
import com.zoho.crm.api.relatedlists.RelatedList;
import com.zoho.crm.api.relatedlists.RelatedListsOperations;
import com.zoho.crm.api.users.Users;
import com.zoho.crm.api.users.UsersOperations;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utility {
    private static HashMap<String, String> apiTypeVsDataType = new HashMap();
    private static HashMap<String, String> apiTypeVsStructureName = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private static Boolean newFile = false;
    private static Boolean getModifiedModules = false;
    private static Boolean forceRefresh = false;
    public static JSONObject apiSupportedModule = new JSONObject();
    private static String moduleAPIName;

    public static void assertNotNull(Object value, String errorCode, String errorMessage) throws SDKException {
        if (value == null) {
            throw new SDKException(errorCode, errorMessage);
        }
    }

    private static synchronized void fileExistsFlow(String moduleAPIName, String recordFieldDetailsPath, String lastModifiedTime) throws IOException, SDKException {
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        if (Initializer.getInitializer().getSDKConfig().getAutoRefreshFields() && !newFile.booleanValue() && !getModifiedModules.booleanValue() && (recordFieldDetailsJson.optString("FIELDS-LAST-MODIFIED-TIME").isEmpty() || forceRefresh.booleanValue() || System.currentTimeMillis() - Long.valueOf(recordFieldDetailsJson.getString("FIELDS-LAST-MODIFIED-TIME")) > 3600000L)) {
            getModifiedModules = true;
            lastModifiedTime = forceRefresh == false && recordFieldDetailsJson.has("FIELDS-LAST-MODIFIED-TIME") ? recordFieldDetailsJson.getString("FIELDS-LAST-MODIFIED-TIME") : null;
            Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
            getModifiedModules = false;
        } else if (!Initializer.getInitializer().getSDKConfig().getAutoRefreshFields() && forceRefresh.booleanValue() && !getModifiedModules.booleanValue()) {
            getModifiedModules = true;
            Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
            getModifiedModules = false;
        }
        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        if (moduleAPIName == null || recordFieldDetailsJson.has(moduleAPIName.toLowerCase())) {
            return;
        }
        Utility.fillDataType();
        recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)new JSONObject());
        FileWriter file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
        JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleAPIName);
        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)fieldDetails);
        file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
    }

    private static String verifyModuleAPIName(String moduleName) throws IOException, SDKException {
        if (moduleName != null && Constants.DEFAULT_MODULENAME_VS_APINAME.get(moduleName.toLowerCase()) != null) {
            return Constants.DEFAULT_MODULENAME_VS_APINAME.get(moduleName.toLowerCase());
        }
        String recordFieldDetailsPath = Utility.getFileName();
        File recordFieldDetails = new File(recordFieldDetailsPath);
        if (recordFieldDetails.exists()) {
            JSONObject fieldsJSON = Initializer.getJSON(recordFieldDetailsPath);
            if (moduleName != null && fieldsJSON.has("SDK-MODULE-METADATA") && fieldsJSON.getJSONObject("SDK-MODULE-METADATA").has(moduleName.toLowerCase())) {
                return fieldsJSON.getJSONObject("SDK-MODULE-METADATA").getJSONObject(moduleName.toLowerCase()).getString("api_name");
            }
        }
        return moduleName;
    }

    private static void setHandlerAPIPath(String moduleAPIName, CommonAPIHandler handlerInstance) {
        if (handlerInstance == null) {
            return;
        }
        String apiPath = handlerInstance.getAPIPath();
        if (apiPath.toLowerCase().contains(moduleAPIName.toLowerCase())) {
            CharSequence[] apiPathSplit = apiPath.split("/");
            for (int i = 0; i < apiPathSplit.length; ++i) {
                if (apiPathSplit[i].equalsIgnoreCase(moduleAPIName)) {
                    apiPathSplit[i] = moduleAPIName;
                    continue;
                }
                if (!Constants.DEFAULT_MODULENAME_VS_APINAME.containsKey(((String)apiPathSplit[i]).toLowerCase()) || Constants.DEFAULT_MODULENAME_VS_APINAME.get(((String)apiPathSplit[i]).toLowerCase()) == null) continue;
                apiPathSplit[i] = Constants.DEFAULT_MODULENAME_VS_APINAME.get(((String)apiPathSplit[i]).toLowerCase());
            }
            apiPath = String.join((CharSequence)"/", apiPathSplit);
            handlerInstance.setAPIPath(apiPath);
        }
    }

    public static synchronized void getCoqlFields(CommonAPIHandler handlerInstance) throws SDKException {
        BodyWrapper request;
        String query;
        String[] values;
        String value;
        String[] modules;
        String module;
        if (handlerInstance.getRequest() != null && handlerInstance.getRequest() instanceof BodyWrapper && (module = (modules = (value = (values = (query = (request = (BodyWrapper)handlerInstance.getRequest()).getSelectQuery()).split("from"))[1].stripLeading()).split(" "))[0]) != null && module.length() > 0) {
            Utility.getFields(module, handlerInstance);
        }
    }

    public static synchronized void getFields(String moduleAPIName, CommonAPIHandler handlerInstance) throws SDKException {
        if (moduleAPIName.contains(",")) {
            String[] modules;
            String[] stringArray = modules = moduleAPIName.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String name;
                Utility.moduleAPIName = name = stringArray[i];
                Utility.getFieldsInfo(name, handlerInstance);
            }
        } else {
            Utility.moduleAPIName = moduleAPIName;
            Utility.getFieldsInfo(moduleAPIName, handlerInstance);
        }
    }

    public static synchronized void getFieldsInfo(String moduleAPIName, CommonAPIHandler handlerInstance) throws SDKException {
        String recordFieldDetailsPath = null;
        String lastModifiedTime = null;
        try {
            File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
            if (!resourcesPath.exists()) {
                resourcesPath.mkdirs();
            }
            moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
            Utility.setHandlerAPIPath(moduleAPIName, handlerInstance);
            if (handlerInstance != null && handlerInstance.getModuleAPIName() == null && !Constants.SKIP_MODULES.contains(moduleAPIName.toLowerCase())) {
                return;
            }
            recordFieldDetailsPath = Utility.getFileName();
            File recordFieldDetails = new File(recordFieldDetailsPath);
            if (recordFieldDetails.exists()) {
                Utility.fileExistsFlow(moduleAPIName, recordFieldDetailsPath, lastModifiedTime);
            } else if (Initializer.getInitializer().getSDKConfig().getAutoRefreshFields()) {
                newFile = true;
                Utility.fillDataType();
                apiSupportedModule = apiSupportedModule.length() > 0 ? apiSupportedModule : Utility.getModules(null);
                JSONObject recordFieldDetailsJson = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
                recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", (Object)String.valueOf(System.currentTimeMillis()));
                if (apiSupportedModule.length() > 0) {
                    for (String module : apiSupportedModule.keySet()) {
                        if (recordFieldDetailsJson.has(module)) continue;
                        JSONObject moduleData = apiSupportedModule.getJSONObject(module);
                        recordFieldDetailsJson.put(module, (Object)new JSONObject());
                        FileWriter file = new FileWriter(recordFieldDetailsPath);
                        file.write(recordFieldDetailsJson.toString());
                        file.flush();
                        file.close();
                        JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleData.getString("api_name"));
                        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                        recordFieldDetailsJson.put(module, (Object)fieldDetails);
                        file = new FileWriter(recordFieldDetailsPath);
                        file.flush();
                        file.write(recordFieldDetailsJson.toString());
                        file.flush();
                        file.close();
                    }
                }
                newFile = false;
            } else if (forceRefresh.booleanValue() && !getModifiedModules.booleanValue()) {
                getModifiedModules = true;
                JSONObject recordFieldDetailsJson = new JSONObject();
                FileWriter file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
                Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
                getModifiedModules = false;
            } else {
                Utility.fillDataType();
                JSONObject recordFieldDetailsJson = new JSONObject();
                recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)new JSONObject());
                FileWriter file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
                JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleAPIName);
                recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)fieldDetails);
                file = new FileWriter(recordFieldDetailsPath);
                file.flush();
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
            }
        }
        catch (SDKException | IOException | JSONException e) {
            if (recordFieldDetailsPath != null && new File(recordFieldDetailsPath).exists()) {
                try {
                    JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                    if (moduleAPIName != null && recordFieldDetailsJson.has(moduleAPIName.toLowerCase())) {
                        recordFieldDetailsJson.remove(moduleAPIName.toLowerCase());
                    }
                    if (newFile.booleanValue()) {
                        if (recordFieldDetailsJson.get("FIELDS-LAST-MODIFIED-TIME") != null) {
                            recordFieldDetailsJson.remove("FIELDS-LAST-MODIFIED-TIME");
                        }
                        newFile = false;
                    }
                    if (getModifiedModules.booleanValue() || forceRefresh.booleanValue()) {
                        getModifiedModules = false;
                        forceRefresh = false;
                        if (lastModifiedTime != null) {
                            recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", lastModifiedTime);
                        }
                    }
                    FileWriter file = new FileWriter(recordFieldDetailsPath);
                    file.flush();
                    file.write(recordFieldDetailsJson.toString());
                    file.flush();
                    file.close();
                }
                catch (IOException ex) {
                    SDKException exception = new SDKException("Exception", ex);
                    LOGGER.log(Level.SEVERE, "Exception", exception);
                    throw exception;
                }
            }
            SDKException exception = e instanceof SDKException ? (SDKException)e : new SDKException("Exception", (Exception)e);
            LOGGER.log(Level.SEVERE, "Exception", exception);
            throw exception;
        }
    }

    private static void modifyFields(String recordFieldDetailsPath, String modifiedTime) throws IOException, SDKException {
        FileWriter file = null;
        JSONObject modifiedModules = Utility.getModules(modifiedTime);
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", (Object)String.valueOf(System.currentTimeMillis()));
        file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
        if (modifiedModules.length() > 0) {
            for (String module : modifiedModules.keySet()) {
                if (!recordFieldDetailsJson.has(module.toLowerCase())) continue;
                Utility.deleteFields(recordFieldDetailsJson, module.toLowerCase());
            }
            file = new FileWriter(recordFieldDetailsPath);
            file.flush();
            file.write(recordFieldDetailsJson.toString());
            file.flush();
            file.close();
            for (String module : modifiedModules.keySet()) {
                JSONObject moduleData = modifiedModules.getJSONObject(module.toLowerCase());
                Utility.getFieldsInfo(moduleData.getString("api_name"), null);
            }
        }
    }

    public static void deleteFields(JSONObject recordFieldDetailsJson, String module) {
        ArrayList subformModules = new ArrayList();
        JSONObject fieldsJSON = recordFieldDetailsJson.getJSONObject(module);
        fieldsJSON.keySet().forEach(key -> {
            JSONObject fieldDetail = fieldsJSON.getJSONObject(key);
            if (fieldDetail.has("subform") && fieldDetail.getBoolean("subform") && fieldDetail.has("module") && recordFieldDetailsJson.has(fieldDetail.getString("module"))) {
                subformModules.add(fieldDetail.getString("module"));
            }
        });
        recordFieldDetailsJson.remove(module);
        if (!subformModules.isEmpty()) {
            for (String subformModule : subformModules) {
                Utility.deleteFields(recordFieldDetailsJson, subformModule);
            }
        }
    }

    private static String getFileName() throws UnsupportedEncodingException, SDKException {
        Converter converterInstance = new Converter(){

            @Override
            public ArrayList<Object> getWrappedResponse(Object response, String pack) throws Exception {
                return null;
            }

            @Override
            public Object getResponse(Object response, String pack) throws Exception {
                return null;
            }

            @Override
            public Object formRequest(Object requestObject, String pack, Integer instanceNumber, JSONObject memberDetail) throws Exception {
                return null;
            }

            @Override
            public void appendToRequest(ClassicHttpRequest requestBase, Object requestObject) throws Exception {
            }
        };
        return Initializer.getInitializer().getResourcePath() + File.separator + "resources" + File.separator + converterInstance.getEncodedFileName();
    }

    public static synchronized void getRelatedLists(String relatedModuleName, String moduleAPIName, CommonAPIHandler commonAPIHandler) throws SDKException {
        try {
            JSONObject recordFieldDetailsJSON;
            JSONArray modulerelatedList;
            FileWriter file;
            String recordFieldDetailsPath;
            File recordFieldDetails;
            boolean isNewData = false;
            String key = (moduleAPIName + "_Related_Lists").toLowerCase();
            File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
            if (!resourcesPath.exists()) {
                resourcesPath.mkdirs();
            }
            if (!(recordFieldDetails = new File(recordFieldDetailsPath = Utility.getFileName())).exists() || recordFieldDetails.exists() && Initializer.getJSON(recordFieldDetailsPath).optJSONArray(key) == null) {
                isNewData = true;
                moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
                JSONArray relatedListValues = Utility.getRelatedListDetails(moduleAPIName);
                JSONObject recordFieldDetailsJSON2 = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
                recordFieldDetailsJSON2.put(key, (Object)relatedListValues);
                file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJSON2.toString());
                file.flush();
                file.close();
            }
            if (!Utility.checkRelatedListExists(relatedModuleName, modulerelatedList = (recordFieldDetailsJSON = Initializer.getJSON(recordFieldDetailsPath)).getJSONArray(key), commonAPIHandler) && !isNewData) {
                recordFieldDetailsJSON.remove(key);
                file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJSON.toString());
                file.flush();
                file.close();
                Utility.getRelatedLists(relatedModuleName, moduleAPIName, commonAPIHandler);
            }
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException("Exception", e);
            LOGGER.log(Level.SEVERE, "Exception", exception);
            throw exception;
        }
    }

    private static boolean checkRelatedListExists(String relatedModuleName, JSONArray modulerelatedListJA, CommonAPIHandler commonAPIHandler) throws JSONException, SDKException {
        for (int index = 0; index < modulerelatedListJA.length(); ++index) {
            JSONObject relatedListJO = modulerelatedListJA.getJSONObject(index);
            if (relatedListJO.getString("api_name") == null || !relatedListJO.getString("api_name").equalsIgnoreCase(relatedModuleName)) continue;
            if (relatedListJO.getString("href").equals("null")) {
                throw new SDKException("API UNSUPPORTED OPERATION", commonAPIHandler.getHttpMethod() + " " + commonAPIHandler.getAPIPath() + " Operation is not supported by API");
            }
            if (!relatedListJO.getString("module").equalsIgnoreCase("null")) {
                commonAPIHandler.setModuleAPIName(relatedListJO.getString("module"));
                Utility.getFieldsInfo(relatedListJO.getString("module"), commonAPIHandler);
            }
            return true;
        }
        return false;
    }

    private static JSONArray getRelatedListDetails(String moduleAPIName) throws SDKException {
        RelatedListsOperations relatedListsOperations = new RelatedListsOperations(null);
        ParameterMap paramInstance = new ParameterMap();
        paramInstance.add(RelatedListsOperations.GetRelatedListsParam.MODULE, moduleAPIName);
        APIResponse<com.zoho.crm.api.relatedlists.ResponseHandler> response = relatedListsOperations.getRelatedLists(paramInstance);
        JSONArray relatedListJA = new JSONArray();
        if (response != null) {
            if (response.getStatusCode() == 204) {
                return relatedListJA;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.relatedlists.ResponseHandler responseHandler = response.getObject();
                if (responseHandler instanceof com.zoho.crm.api.relatedlists.ResponseWrapper) {
                    com.zoho.crm.api.relatedlists.ResponseWrapper responseWrapper = (com.zoho.crm.api.relatedlists.ResponseWrapper)responseHandler;
                    ArrayList relatedLists = (ArrayList)responseWrapper.getRelatedLists();
                    for (RelatedList relatedList : relatedLists) {
                        JSONObject relatedListDetail = new JSONObject();
                        relatedListDetail.put("api_name", (Object)relatedList.getAPIName());
                        relatedListDetail.put("module", (Object)(relatedList.getModule() != null ? relatedList.getModule().getAPIName() : "null"));
                        relatedListDetail.put("name", (Object)relatedList.getName());
                        relatedListDetail.put("href", (Object)(relatedList.getHref() != null ? relatedList.getHref() : "null"));
                        relatedListJA.put((Object)relatedListDetail);
                    }
                } else if (responseHandler instanceof com.zoho.crm.api.relatedlists.APIException) {
                    com.zoho.crm.api.relatedlists.APIException exception = (com.zoho.crm.api.relatedlists.APIException)responseHandler;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage());
                    throw new SDKException("API_EXCEPTION", errorResponse);
                }
            } else {
                JSONObject errorResponse = new JSONObject();
                errorResponse.put("code", response.getStatusCode());
                throw new SDKException("API_EXCEPTION", errorResponse);
            }
        }
        return relatedListJA;
    }

    public static Object getFieldsDetails(String moduleAPIName) throws SDKException {
        JSONObject fieldsDetails = new JSONObject();
        FieldsOperations fieldOperation = new FieldsOperations();
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.add(FieldsOperations.GetFieldsParam.MODULE, moduleAPIName);
        APIResponse<com.zoho.crm.api.fields.ResponseHandler> response = fieldOperation.getFields(parameterMap);
        if (response != null) {
            if (response.getStatusCode() == 204) {
                return fieldsDetails;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.fields.ResponseHandler responseHandler = response.getObject();
                if (responseHandler instanceof com.zoho.crm.api.fields.ResponseWrapper) {
                    JSONObject fieldDetail;
                    com.zoho.crm.api.fields.ResponseWrapper responseWrapper = (com.zoho.crm.api.fields.ResponseWrapper)responseHandler;
                    ArrayList fields = (ArrayList)responseWrapper.getFields();
                    for (Fields field : fields) {
                        String keyName = field.getAPIName();
                        if (Constants.KEYS_TO_SKIP.contains(keyName)) continue;
                        JSONObject fieldDetail2 = new JSONObject();
                        Utility.setDataType(fieldDetail2, field, moduleAPIName);
                        fieldsDetails.put(field.getAPIName(), (Object)fieldDetail2);
                    }
                    if (Constants.INVENTORY_MODULES.contains(moduleAPIName.toLowerCase())) {
                        fieldDetail = new JSONObject();
                        fieldDetail.put("name", (Object)"$line_tax");
                        fieldDetail.put("type", (Object)"java.util.List");
                        fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.LineTax");
                        fieldDetail.put("lookup", true);
                        fieldsDetails.put("$line_tax", (Object)fieldDetail);
                    }
                    if ("Notes".equalsIgnoreCase(moduleAPIName)) {
                        fieldDetail = new JSONObject();
                        fieldDetail.put("name", (Object)"$attachments");
                        fieldDetail.put("type", (Object)"java.util.List");
                        fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.attachments.Attachment");
                        fieldsDetails.put("$attachments", (Object)fieldDetail);
                    }
                } else if (responseHandler instanceof com.zoho.crm.api.fields.APIException) {
                    com.zoho.crm.api.fields.APIException exception = (com.zoho.crm.api.fields.APIException)responseHandler;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage());
                    SDKException exception1 = new SDKException("API_EXCEPTION", errorResponse);
                    if (Utility.moduleAPIName != null && Utility.moduleAPIName.equalsIgnoreCase(moduleAPIName)) {
                        throw exception1;
                    }
                    LOGGER.log(Level.SEVERE, "API_EXCEPTION", exception1);
                }
            } else {
                JSONObject errorResponse = new JSONObject();
                errorResponse.put("code", response.getStatusCode());
                throw new SDKException("API_EXCEPTION", errorResponse);
            }
        }
        return fieldsDetails;
    }

    public static synchronized boolean verifyPhotoSupport(String moduleAPIName) throws SDKException {
        try {
            JSONObject moduleMetaData;
            moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
            if (Constants.PHOTO_SUPPORTED_MODULES.contains(moduleAPIName.toLowerCase())) {
                return true;
            }
            JSONObject modules = Utility.getModuleNames();
            if (modules.optJSONObject(moduleAPIName.toLowerCase()) != null && (moduleMetaData = modules.getJSONObject(moduleAPIName.toLowerCase())).has("generated_type") && !moduleMetaData.getString("generated_type").equals("custom")) {
                throw new SDKException("UPLOAD PHOTO UNSUPPORTED MODULE", "Photo Upload Operation is not supported by the module: " + moduleAPIName);
            }
        }
        catch (SDKException e) {
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException("Exception", e);
            throw exception;
        }
        return true;
    }

    private static synchronized JSONObject getModuleNames() throws Exception {
        String recordFieldDetailsPath;
        File recordFieldDetails;
        JSONObject moduleData = new JSONObject();
        File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
        if (!resourcesPath.exists()) {
            resourcesPath.mkdirs();
        }
        if (!(recordFieldDetails = new File(recordFieldDetailsPath = Utility.getFileName())).exists() || recordFieldDetails.exists() && (Initializer.getJSON(recordFieldDetailsPath).optJSONObject("SDK-MODULE-METADATA") == null || Initializer.getJSON(recordFieldDetailsPath).optJSONObject("SDK-MODULE-METADATA").length() == 0)) {
            moduleData = Utility.getModules(null);
            Utility.writeModuleMetaData(recordFieldDetailsPath, moduleData);
            return moduleData;
        }
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        moduleData = recordFieldDetailsJson.getJSONObject("SDK-MODULE-METADATA");
        return moduleData;
    }

    private static void writeModuleMetaData(String recordFieldDetailsPath, JSONObject moduleData) throws IOException {
        JSONObject moduleDataJSON = new JSONObject();
        moduleData.keySet().forEach(key -> moduleDataJSON.put(key, moduleData.get(key)));
        File recordFieldDetails = new File(recordFieldDetailsPath);
        JSONObject fieldDetailsJSON = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
        fieldDetailsJSON.put("SDK-MODULE-METADATA", (Object)moduleDataJSON);
        FileWriter file = new FileWriter(recordFieldDetailsPath);
        file.write(fieldDetailsJSON.toString());
        file.flush();
        file.close();
    }

    private static synchronized JSONObject getModules(String header) throws SDKException {
        APIResponse<com.zoho.crm.api.modules.ResponseHandler> response;
        JSONObject apiNames = new JSONObject();
        HeaderMap headerMap = new HeaderMap();
        ParameterMap paramInstance = new ParameterMap();
        if (header != null) {
            OffsetDateTime headerValue = OffsetDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(header)), ZoneId.systemDefault()).withNano(0);
            headerMap.add(ModulesOperations.GetModulesHeader.IF_MODIFIED_SINCE, headerValue);
        }
        if ((response = new ModulesOperations().getModules(paramInstance, headerMap)) != null) {
            if (Arrays.asList(204, 304).contains(response.getStatusCode())) {
                return apiNames;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.modules.ResponseHandler responseObject = response.getObject();
                if (responseObject instanceof com.zoho.crm.api.modules.ResponseWrapper) {
                    List<Modules> modules = ((com.zoho.crm.api.modules.ResponseWrapper)responseObject).getModules();
                    for (Modules module : modules) {
                        if (!module.getAPISupported().booleanValue()) continue;
                        JSONObject moduleDetails = new JSONObject();
                        moduleDetails.put("api_name", (Object)module.getAPIName());
                        moduleDetails.put("generated_type", (Object)module.getGeneratedType().getValue());
                        apiNames.put(module.getAPIName().toLowerCase(), (Object)moduleDetails);
                    }
                } else if (responseObject instanceof APIException) {
                    APIException exception = (APIException)responseObject;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage());
                    throw new SDKException("API_EXCEPTION", errorResponse);
                }
            }
        }
        if (header == null) {
            try {
                File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
                if (!resourcesPath.exists()) {
                    resourcesPath.mkdirs();
                }
                Utility.writeModuleMetaData(Utility.getFileName(), apiNames);
            }
            catch (IOException e) {
                throw new SDKException("Exception", e);
            }
        }
        return apiNames;
    }

    public static void refreshModules() throws SDKException {
        forceRefresh = true;
        Utility.getFieldsInfo(null, null);
        forceRefresh = false;
    }

    public static JSONObject getJSONObject(JSONObject json, String key) {
        for (String keyInJSON : json.keySet()) {
            if (!keyInJSON.equalsIgnoreCase(key)) continue;
            return json.getJSONObject(keyInJSON);
        }
        return null;
    }

    private static void setDataType(JSONObject fieldDetail, Fields field, String moduleAPIName) throws SDKException {
        LinkingModule linkingModule;
        LinkingDetails linkingDetails;
        String returnType;
        String apiType = field.getDataType();
        String keyName = field.getAPIName();
        MinifiedModule module = new MinifiedModule();
        if (!(field.getSystemMandatory() == null || !field.getSystemMandatory().booleanValue() || moduleAPIName.equalsIgnoreCase("Calls") && keyName.equalsIgnoreCase("Call_Duration"))) {
            fieldDetail.put("required", true);
        }
        if (keyName.equalsIgnoreCase("Pricing_Details") && moduleAPIName.equalsIgnoreCase("Price_Books")) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.PricingDetails");
            fieldDetail.put("skip-mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Participants") && (moduleAPIName.equalsIgnoreCase("Events") || moduleAPIName.equalsIgnoreCase("Activities"))) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Participants");
            fieldDetail.put("skip-mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Comments") && (moduleAPIName.equalsIgnoreCase("Solutions") || moduleAPIName.equalsIgnoreCase("Cases"))) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Comment");
            fieldDetail.put("lookup", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Layout")) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"com.zoho.crm.api.layouts.Layouts");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.layouts.Layouts");
            fieldDetail.put("lookup", true);
            return;
        }
        if ((keyName.equalsIgnoreCase("territories") || keyName.equalsIgnoreCase("Territory")) && field.getCustomField() != null && !field.getCustomField().booleanValue()) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Territory");
            fieldDetail.put("lookup", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Product_Name") && Constants.INVENTORY_MODULES_ITEMS.contains(moduleAPIName.toLowerCase())) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"com.zoho.crm.api.record.LineItemProduct");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.LineItemProduct");
            fieldDetail.put("skip-mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("DISCOUNT") && Constants.INVENTORY_MODULES_ITEMS.contains(moduleAPIName.toLowerCase())) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.lang.String");
            return;
        }
        if (keyName.equalsIgnoreCase("TAX") && moduleAPIName.toLowerCase().equalsIgnoreCase("Products")) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Tax");
            return;
        }
        if (apiTypeVsDataType.containsKey(apiType)) {
            fieldDetail.put("type", (Object)apiTypeVsDataType.get(apiType));
        } else if (apiType.equalsIgnoreCase("formula")) {
            if (field.getFormula() != null && apiTypeVsDataType.get(returnType = field.getFormula().getReturnType()) != null) {
                fieldDetail.put("type", (Object)apiTypeVsDataType.get(returnType));
            }
            fieldDetail.put("read-only", true);
        } else if (apiType.equalsIgnoreCase("rollup_summary")) {
            if (field.getRollupSummary() != null) {
                returnType = field.getRollupSummary().getReturnType();
                if (apiTypeVsDataType.get(returnType) != null) {
                    fieldDetail.put("type", (Object)apiTypeVsDataType.get(returnType));
                } else if (apiTypeVsDataType.get(field.getJsonType()) != null) {
                    fieldDetail.put("type", (Object)apiTypeVsDataType.get(field.getJsonType()));
                }
            }
        } else {
            return;
        }
        if (apiType.toLowerCase().contains("lookup")) {
            fieldDetail.put("lookup", true);
        }
        if (apiType.toLowerCase().equalsIgnoreCase("consent_lookup") || apiType.toLowerCase().equalsIgnoreCase("ownerlookup")) {
            fieldDetail.put("skip-mandatory", true);
        }
        if (apiType.toLowerCase().equalsIgnoreCase("multiselectlookup")) {
            fieldDetail.put("skip-mandatory", true);
            Multiselectlookup multiselectlookup = field.getMultiselectlookup();
            if (multiselectlookup != null && (linkingDetails = multiselectlookup.getLinkingDetails()) != null) {
                linkingModule = linkingDetails.getModule();
                fieldDetail.put("module", (Object)linkingModule.getAPIName());
                module = new MinifiedModule();
                module.setAPIName(linkingModule.getAPIName());
                module.setId(linkingModule.getId());
            }
            fieldDetail.put("subform", true);
        }
        if (apiType.toLowerCase().equalsIgnoreCase("multiuserlookup")) {
            fieldDetail.put("skip-mandatory", true);
            Multiselectlookup multiuserlookup = field.getMultiuserlookup();
            if (multiuserlookup != null && (linkingDetails = multiuserlookup.getLinkingDetails()) != null) {
                linkingModule = linkingDetails.getModule();
                fieldDetail.put("module", (Object)linkingModule.getAPIName());
                module = new MinifiedModule();
                module.setAPIName(linkingModule.getAPIName());
                module.setId(linkingModule.getId());
            }
            fieldDetail.put("subform", true);
        }
        if (apiType.toLowerCase().equalsIgnoreCase("multi_module_lookup")) {
            fieldDetail.put("skip-mandatory", true);
        }
        if (apiTypeVsStructureName.containsKey(apiType)) {
            fieldDetail.put("structure_name", (Object)apiTypeVsStructureName.get(apiType));
        }
        if (apiType.equalsIgnoreCase("picklist") && field.getPickListValues() != null && field.getPickListValues().size() > 0) {
            fieldDetail.put("picklist", true);
            JSONArray values = new JSONArray();
            field.getPickListValues().forEach(plv -> values.put((Object)plv.getDisplayValue()));
            fieldDetail.put("values", (Object)values);
        }
        if (apiType.equalsIgnoreCase("subform")) {
            module.setAPIName(field.getAssociatedModule().getModule());
            fieldDetail.put("module", (Object)module.getAPIName());
            fieldDetail.put("skip-mandatory", true);
            fieldDetail.put("subform", true);
        }
        if (apiType.equalsIgnoreCase("lookup") && field.getLookup() != null) {
            MinifiedModule module1 = field.getLookup().getModule();
            if (module1 != null && !module1.getAPIName().equalsIgnoreCase("se_module")) {
                module.setAPIName(module1.getAPIName());
                module.setId(module1.getId());
                fieldDetail.put("module", (Object)module1.getAPIName());
                if (module1.getAPIName().equalsIgnoreCase("Accounts") && !field.getCustomField().booleanValue()) {
                    fieldDetail.put("skip-mandatory", true);
                }
            } else {
                module = new MinifiedModule();
            }
            fieldDetail.put("lookup", true);
        }
        if (module != null && module.getAPIName() != null && module.getAPIName().length() > 0) {
            Utility.getFieldsInfo(module.getAPIName(), null);
        }
        fieldDetail.put("name", (Object)keyName);
    }

    private static void fillDataType() {
        if (!apiTypeVsDataType.isEmpty()) {
            return;
        }
        String[] fieldAPINamesString = new String[]{"textarea", "text", "website", "email", "phone", "mediumtext", "profileimage", "autonumber"};
        String[] fieldAPINamesInteger = new String[]{"integer"};
        String[] fieldAPINamesBoolean = new String[]{"boolean"};
        String[] fieldAPINamesLong = new String[]{"long", "bigint"};
        String[] fieldAPINamesDouble = new String[]{"double", "percent", "currency"};
        String[] fieldAPINamesFieldFile = new String[]{"fileupload"};
        String[] fieldAPINamesDateTime = new String[]{"datetime", "event_reminder"};
        String[] fieldAPINamesDate = new String[]{"date"};
        String[] fieldAPINamesLookup = new String[]{"lookup"};
        String[] fieldAPINamesPickList = new String[]{"picklist"};
        String[] fieldAPINamesMultiSelectPickList = new String[]{"multiselectpicklist"};
        String[] fieldAPINamesSubForm = new String[]{"subform"};
        String[] fieldAPINamesOwnerLookUp = new String[]{"ownerlookup", "userlookup"};
        String[] fieldAPINamesMultiUserLookUp = new String[]{"multiuserlookup"};
        String[] fieldAPINameTaskRemindAt = new String[]{"ALARM"};
        String[] fieldAPINameRecurringActivity = new String[]{"RRULE"};
        String[] fieldAPINameReminder = new String[]{"multireminder"};
        String[] fieldAPINameConsentLookUp = new String[]{"consent_lookup"};
        String[] fieldAPINameImageUpload = new String[]{"imageupload"};
        String[] fieldAPInameMultiSelectLookUp = new String[]{"multiselectlookup"};
        String[] fieldAPINameLineTax = new String[]{"linetax"};
        String[] fieldAPINamesModule = new String[]{"module"};
        String[] fieldAPINamesLayout = new String[]{"layout"};
        String[] fieldAPINamesMultiModuleLookUp = new String[]{"multi_module_lookup"};
        String[] fieldAPINamesTimeRange = new String[]{"time_range"};
        for (String fieldAPIName : fieldAPINamesString) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.String");
        }
        for (String fieldAPIName : fieldAPINamesInteger) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Integer");
        }
        for (String fieldAPIName : fieldAPINamesBoolean) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Boolean");
        }
        for (String fieldAPIName : fieldAPINamesLong) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Long");
        }
        for (String fieldAPIName : fieldAPINamesDouble) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Double");
        }
        for (String fieldAPIName : fieldAPINamesDateTime) {
            apiTypeVsDataType.put(fieldAPIName, "java.time.OffsetDateTime");
        }
        for (String fieldAPIName : fieldAPINamesDate) {
            apiTypeVsDataType.put(fieldAPIName, "java.time.LocalDate");
        }
        for (String fieldAPIName : fieldAPINamesLookup) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.Record");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesPickList) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.util.Choice");
        }
        for (String fieldAPIName : fieldAPINamesMultiSelectPickList) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.util.Choice");
        }
        for (String fieldAPIName : fieldAPINamesSubForm) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesOwnerLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.users.MinifiedUser");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.users.MinifiedUser");
        }
        for (String fieldAPIName : fieldAPINamesMultiUserLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesFieldFile) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.FileDetails");
        }
        for (String fieldAPIName : fieldAPINameTaskRemindAt) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.RemindAt");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.RemindAt");
        }
        for (String fieldAPIName : fieldAPINameRecurringActivity) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.RecurringActivity");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.RecurringActivity");
        }
        for (String fieldAPIName : fieldAPINameReminder) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Reminder");
        }
        for (String fieldAPIName : fieldAPINameConsentLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.Consent");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Consent");
        }
        for (String fieldAPIName : fieldAPINameImageUpload) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.ImageUpload");
        }
        for (String fieldAPIName : fieldAPInameMultiSelectLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINameLineTax) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.LineTax");
        }
        for (String fieldAPIName : fieldAPINamesModule) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.modules.Modules");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.modules.Modules");
        }
        for (String fieldAPIName : fieldAPINamesMultiModuleLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.Record");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesLayout) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.layouts.Layouts");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.layouts.Layouts");
        }
        for (String fieldAPIName : fieldAPINamesTimeRange) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.TimeRange");
        }
    }

    public String getUserName(String token) throws Exception {
        String userName = null;
        ParameterMap paramInstance = new ParameterMap();
        paramInstance.add(UsersOperations.GetUsersParam.TYPE, "CurrentUser");
        HeaderMap headerInstance = new HeaderMap();
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        headerInstance.add(new Header("Authorization", "java.lang.String"), "Zoho-oauthtoken " + token);
        handlerInstance.setHeader(headerInstance);
        APIResponse<com.zoho.crm.api.users.ResponseHandler> response = handlerInstance.apiCall(com.zoho.crm.api.users.ResponseHandler.class, "application/json");
        if (response != null) {
            if (Arrays.asList(204, 304).contains(response.getStatusCode())) {
                return null;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.users.ResponseHandler responseHandler = response.getObject();
                if (responseHandler instanceof com.zoho.crm.api.users.ResponseWrapper) {
                    com.zoho.crm.api.users.ResponseWrapper responseWrapper = (com.zoho.crm.api.users.ResponseWrapper)responseHandler;
                    List<Users> users = responseWrapper.getUsers();
                    Iterator<Users> iterator = users.iterator();
                    if (iterator.hasNext()) {
                        Users user = iterator.next();
                        userName = user.getEmail();
                    }
                } else if (responseHandler instanceof com.zoho.crm.api.users.APIException) {
                    com.zoho.crm.api.users.APIException exception = (com.zoho.crm.api.users.APIException)responseHandler;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage());
                    throw new SDKException("API_EXCEPTION", errorResponse);
                }
            }
        }
        String orgID = this.getUserOrgID(token);
        if (userName == null || orgID == null) {
            return null;
        }
        return userName + ":" + orgID;
    }

    private String getUserOrgID(String token) throws Exception {
        HeaderMap headerInstance = new HeaderMap();
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/org");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        headerInstance.add(new Header("Authorization", "java.lang.String"), "Zoho-oauthtoken " + token);
        handlerInstance.setHeader(headerInstance);
        APIResponse<ResponseHandler> response = handlerInstance.apiCall(ResponseHandler.class, "application/json");
        if (response != null && response.isExpected()) {
            ResponseHandler responseHandler = response.getObject();
            if (responseHandler instanceof ResponseWrapper) {
                ResponseWrapper responseWrapper = (ResponseWrapper)responseHandler;
                List<Org> orgs = responseWrapper.getOrg();
                Iterator<Org> iterator = orgs.iterator();
                if (iterator.hasNext()) {
                    Org org = iterator.next();
                    return org.getZgid();
                }
            } else if (responseHandler instanceof com.zoho.crm.api.org.APIException) {
                com.zoho.crm.api.org.APIException exception = (com.zoho.crm.api.org.APIException)responseHandler;
                JSONObject errorResponse = new JSONObject();
                errorResponse.put("code", (Object)exception.getCode().getValue());
                errorResponse.put("status", (Object)exception.getStatus().getValue());
                errorResponse.put("message", exception.getMessage());
                throw new SDKException("API_EXCEPTION", errorResponse);
            }
        }
        return null;
    }
}

