/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.util.Choice;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Converter;
import com.zoho.crm.api.util.DataTypeConverter;
import com.zoho.crm.api.util.Utility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONConverter
extends Converter {
    private HashMap<String, ArrayList<Object>> uniqueValuesMap = new HashMap();

    public JSONConverter(CommonAPIHandler commonAPIHandler) {
        super(commonAPIHandler);
    }

    @Override
    public void appendToRequest(ClassicHttpRequest requestBase, Object requestObject) throws Exception {
        requestBase.setEntity((HttpEntity)new StringEntity(requestObject.toString(), StandardCharsets.UTF_8));
    }

    @Override
    public Object formRequest(Object requestInstance, String pack, Integer instanceNumber, JSONObject memberDetail) throws Exception {
        JSONObject classDetail = (JSONObject)Initializer.jsonDetails.get(pack);
        if (classDetail.has("interface") && classDetail.getBoolean("interface")) {
            JSONArray classes = classDetail.getJSONArray("classes");
            String requestObjectClassName = requestInstance.getClass().getCanonicalName();
            for (Object className : classes) {
                if (!((String)className).equalsIgnoreCase(requestObjectClassName)) continue;
                classDetail = (JSONObject)Initializer.jsonDetails.get(requestObjectClassName);
                break;
            }
        }
        if (requestInstance instanceof Record) {
            String moduleAPIName = this.commonAPIHandler.getModuleAPIName();
            JSONObject returnJSON = this.isRecordRequest(requestInstance, classDetail, instanceNumber, memberDetail);
            this.commonAPIHandler.setModuleAPIName(moduleAPIName);
            return returnJSON;
        }
        return this.isNotRecordRequest(requestInstance, classDetail, instanceNumber, memberDetail);
    }

    private JSONObject isNotRecordRequest(Object requestInstance, JSONObject classDetail, Integer instanceNumber, JSONObject classMemberDetail) throws Exception {
        Boolean lookUp = false;
        Boolean skipMandatory = false;
        String classMemberName = null;
        if (classMemberDetail != null) {
            lookUp = classMemberDetail.optBoolean("lookup");
            skipMandatory = classMemberDetail.optBoolean("skip-mandatory");
            classMemberName = this.buildName(classMemberDetail.getString("name"));
        }
        JSONObject requestJSON = new JSONObject();
        HashMap<String, Boolean> requiredKeys = new HashMap<String, Boolean>();
        HashMap<String, Boolean> primaryKeys = new HashMap<String, Boolean>();
        HashMap<String, Boolean> requiredInUpdateKeys = new HashMap<String, Boolean>();
        for (String memberName : classDetail.keySet()) {
            Object modification = null;
            JSONObject memberDetail = (JSONObject)classDetail.get(memberName);
            if (memberDetail.has("read-only") && memberDetail.getBoolean("read-only") || !memberDetail.has("name")) continue;
            String keyName = memberDetail.getString("name");
            try {
                Method isKeyModified = requestInstance.getClass().getMethod("isKeyModified", String.class);
                modification = isKeyModified.invoke(requestInstance, keyName);
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                throw new SDKException("Exception in calling isKeyModified : ", ex);
            }
            if (memberDetail.has("required") && memberDetail.getBoolean("required")) {
                requiredKeys.put(keyName, true);
            }
            if (memberDetail.has("required-in-update") && memberDetail.getBoolean("required-in-update")) {
                requiredInUpdateKeys.put(keyName, true);
            }
            if (memberDetail.has("primary") && memberDetail.getBoolean("primary") && (!memberDetail.has("required-in-update") || memberDetail.getBoolean("required-in-update"))) {
                primaryKeys.put(keyName, true);
            }
            Object fieldValue = null;
            if (modification == null || (Integer)modification == 0) continue;
            Field field = requestInstance.getClass().getDeclaredField(memberName);
            field.setAccessible(true);
            fieldValue = field.get(requestInstance);
            if (fieldValue != null && this.valueChecker(requestInstance.getClass().getSimpleName(), memberName, memberDetail, fieldValue, this.uniqueValuesMap, instanceNumber)) {
                requiredKeys.remove(keyName);
                primaryKeys.remove(keyName);
                requiredInUpdateKeys.remove(keyName);
            }
            if (keyName.equalsIgnoreCase("body") && this.commonAPIHandler.getAPIPath().endsWith("/actions/execute") && this.commonAPIHandler.getAPIPath().contains("v8/functions")) {
                return (JSONObject)this.setData(memberDetail, fieldValue);
            }
            requestJSON.put(keyName, this.setData(memberDetail, fieldValue));
        }
        if (skipMandatory.booleanValue() || this.checkException(classMemberName, requestInstance, instanceNumber, lookUp, requiredKeys, primaryKeys, requiredInUpdateKeys).booleanValue()) {
            return requestJSON;
        }
        return requestJSON;
    }

    private Boolean checkException(String memberName, Object requestInstance, Integer instanceNumber, Boolean lookUp, HashMap<String, Boolean> requiredKeys, HashMap<String, Boolean> primaryKeys, HashMap<String, Boolean> requiredInUpdateKeys) throws SDKException {
        if (requiredInUpdateKeys.size() > 0 && this.commonAPIHandler.getCategoryMethod().equalsIgnoreCase("UPDATE")) {
            JSONObject error = new JSONObject();
            error.put("field", (Object)memberName);
            error.put("type", (Object)requestInstance.getClass().getCanonicalName());
            error.put("keys", (Object)requiredInUpdateKeys.keySet().toString());
            error.put("instance-number", (Object)instanceNumber);
            throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :", error, null);
        }
        if (this.commonAPIHandler.isMandatoryChecker() != null && this.commonAPIHandler.isMandatoryChecker().booleanValue()) {
            if (this.commonAPIHandler.getCategoryMethod().equalsIgnoreCase("CREATE")) {
                if (lookUp.booleanValue()) {
                    if (primaryKeys.size() > 0) {
                        JSONObject error = new JSONObject();
                        error.put("field", (Object)memberName);
                        error.put("type", (Object)requestInstance.getClass().getCanonicalName());
                        error.put("keys", (Object)primaryKeys.keySet().toString());
                        error.put("instance-number", (Object)instanceNumber);
                        throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for required key(s) : ", error, null);
                    }
                } else if (requiredKeys.size() > 0) {
                    JSONObject error = new JSONObject();
                    error.put("field", (Object)memberName);
                    error.put("type", (Object)requestInstance.getClass().getCanonicalName());
                    error.put("keys", (Object)requiredKeys.keySet().toString());
                    error.put("instance-number", (Object)instanceNumber);
                    throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :", error, null);
                }
            }
            if (this.commonAPIHandler.getCategoryMethod().equalsIgnoreCase("UPDATE") && primaryKeys.size() > 0) {
                JSONObject error = new JSONObject();
                error.put("field", (Object)memberName);
                error.put("type", (Object)requestInstance.getClass().getCanonicalName());
                error.put("keys", (Object)primaryKeys.keySet().toString());
                error.put("instance-number", (Object)instanceNumber);
                throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for required key(s) : ", error, null);
            }
        } else if (lookUp.booleanValue() && this.commonAPIHandler.getCategoryMethod().equalsIgnoreCase("UPDATE") && primaryKeys.size() > 0) {
            JSONObject error = new JSONObject();
            error.put("field", (Object)memberName);
            error.put("type", (Object)requestInstance.getClass().getCanonicalName());
            error.put("keys", (Object)primaryKeys.keySet().toString());
            error.put("instance-number", (Object)instanceNumber);
            throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for required key(s) : ", error, null);
        }
        return true;
    }

    private JSONObject isRecordRequest(Object recordInstance, JSONObject classDetail, Integer instanceNumber, JSONObject memberDetail) throws JSONException, Exception {
        JSONObject keyDetail;
        Boolean lookUp = false;
        Boolean skipMandatory = false;
        String classMemberName = null;
        if (memberDetail != null) {
            lookUp = memberDetail.optBoolean("lookup");
            skipMandatory = memberDetail.optBoolean("skip-mandatory");
            classMemberName = memberDetail.optString("name");
        }
        JSONObject requestJSON = new JSONObject();
        JSONObject moduleDetail = new JSONObject();
        String moduleAPIName = this.commonAPIHandler.getModuleAPIName();
        if (moduleAPIName != null) {
            this.commonAPIHandler.setModuleAPIName(null);
            moduleDetail = this.getModuleDetailFromUserSpecJSON(moduleAPIName);
        } else {
            moduleDetail = classDetail;
            classDetail = Initializer.jsonDetails.getJSONObject("com.zoho.crm.api.record.Record");
        }
        Class<?> cl = recordInstance.getClass();
        Class<?> scl = cl.getSuperclass();
        if (scl.getCanonicalName().equals("com.zoho.crm.api.record.Record")) {
            cl = scl;
        }
        Field keyValueField = cl.getDeclaredField("keyValues");
        keyValueField.setAccessible(true);
        Field keyModifiedField = cl.getDeclaredField("keyModified");
        keyModifiedField.setAccessible(true);
        HashMap keyValues = (HashMap)keyValueField.get(recordInstance);
        HashMap keyModified = (HashMap)keyModifiedField.get(recordInstance);
        HashMap<String, Boolean> requiredKeys = new HashMap<String, Boolean>();
        HashMap<String, Boolean> primaryKeys = new HashMap<String, Boolean>();
        if (!skipMandatory.booleanValue()) {
            String name;
            for (String keyName : moduleDetail.keySet()) {
                keyDetail = moduleDetail.optJSONObject(keyName);
                if (keyDetail == null || !keyDetail.has("name")) continue;
                name = keyDetail.getString("name");
                if (keyDetail.has("required") && keyDetail.getBoolean("required")) {
                    requiredKeys.put(name, true);
                }
                if (!keyDetail.has("primary") || !keyDetail.getBoolean("primary")) continue;
                primaryKeys.put(name, true);
            }
            for (String keyName : classDetail.keySet()) {
                keyDetail = classDetail.getJSONObject(keyName);
                name = keyDetail.getString("name");
                if (keyDetail.has("required") && keyDetail.getBoolean("required")) {
                    requiredKeys.put(name, true);
                }
                if (!keyDetail.has("primary") || !keyDetail.getBoolean("primary")) continue;
                primaryKeys.put(name, true);
            }
        }
        for (String keyName : keyModified.keySet()) {
            if ((Integer)keyModified.get(keyName) != 1) continue;
            keyDetail = new JSONObject();
            Object keyValue = keyValues.containsKey(keyName) ? (Object)keyValues.get(keyName) : null;
            Object jsonValue = null;
            String memberName = this.buildName(keyName);
            boolean customHandling = false;
            if (moduleDetail.length() > 0 && (moduleDetail.has(keyName) || moduleDetail.has(memberName))) {
                keyDetail = moduleDetail.has(keyName) ? moduleDetail.optJSONObject(keyName) : moduleDetail.optJSONObject(memberName);
            } else if (classDetail.has(memberName)) {
                keyDetail = classDetail.getJSONObject(memberName);
            } else {
                customHandling = true;
            }
            if (keyValue != null) {
                if (keyDetail != null && keyDetail.length() > 0) {
                    if (keyDetail.has("read-only") && keyDetail.getBoolean("read-only") || !keyDetail.has("name")) continue;
                    if (this.valueChecker(cl.getSimpleName(), memberName, keyDetail, keyValue, this.uniqueValuesMap, instanceNumber)) {
                        jsonValue = this.setData(keyDetail, keyValue);
                    }
                } else {
                    if (keyDetail == null || keyDetail.length() == 0) {
                        keyDetail = new JSONObject();
                        customHandling = true;
                    }
                    if (customHandling && !(keyValue instanceof List) && !(keyValue instanceof Map) && !(keyValue instanceof Choice)) {
                        if (Constants.PRIMITIVE_TYPES.contains(keyValue.getClass().getSimpleName())) {
                            keyDetail.put("type", (Object)keyValue.getClass().getCanonicalName());
                            jsonValue = this.setData(keyDetail, keyValue);
                        } else if (Initializer.jsonDetails.has(keyValue.getClass().getCanonicalName())) {
                            keyDetail.put("structure_name", (Object)keyValue.getClass().getCanonicalName()).put("name", (Object)keyName).put("type", (Object)keyValue.getClass().getCanonicalName());
                            jsonValue = this.setData(keyDetail, keyValue);
                        }
                    } else if (customHandling && keyValue instanceof List) {
                        if (Initializer.jsonDetails.has(((List)keyValue).get(0).getClass().getCanonicalName())) {
                            keyDetail.put("structure_name", (Object)((List)keyValue).get(0).getClass().getCanonicalName()).put("name", (Object)keyName).put("type", (Object)((List)keyValue).get(0).getClass().getCanonicalName());
                            jsonValue = this.setJSONArray(keyValue, keyDetail);
                        } else {
                            jsonValue = this.redirectorForObjectToJSON(keyValue);
                        }
                    } else {
                        jsonValue = this.redirectorForObjectToJSON(keyValue);
                    }
                }
            } else {
                jsonValue = JSONObject.NULL;
            }
            if (keyValue != null) {
                requiredKeys.remove(keyName);
                primaryKeys.remove(keyName);
            }
            requestJSON.put(keyName, jsonValue);
        }
        if (skipMandatory.booleanValue() || this.checkException(classMemberName, recordInstance, instanceNumber, lookUp, requiredKeys, primaryKeys, new HashMap<String, Boolean>()).booleanValue()) {
            return requestJSON;
        }
        return requestJSON;
    }

    private Object setData(JSONObject memberDetail, Object fieldValue) throws JSONException, Exception {
        if (fieldValue != null) {
            String type = (String)memberDetail.get("type");
            return this.setDataValue(type, memberDetail, fieldValue);
        }
        return JSONObject.NULL;
    }

    private Object setDataValue(String type, JSONObject memberDetail, Object fieldValue) throws Exception {
        if (type.equalsIgnoreCase("java.util.List")) {
            return this.setJSONArray(fieldValue, memberDetail);
        }
        if (type.equalsIgnoreCase("java.util.Map")) {
            return this.setJSONObject(fieldValue, memberDetail);
        }
        if (type.equals("com.zoho.crm.api.util.Choice") || memberDetail.has("structure_name") && memberDetail.getString("structure_name").equals("com.zoho.crm.api.util.Choice")) {
            return ((Choice)fieldValue).getValue();
        }
        if (memberDetail.has("structure_name") && memberDetail.has("module")) {
            return this.isRecordRequest(fieldValue, this.getModuleDetailFromUserSpecJSON(memberDetail.getString("module")), null, memberDetail);
        }
        if (memberDetail.has("structure_name")) {
            return this.formRequest(fieldValue, memberDetail.getString("structure_name"), null, memberDetail);
        }
        return DataTypeConverter.postConvert(fieldValue, type);
    }

    private JSONObject setJSONObject(Object fieldValue, JSONObject memberDetail) throws Exception {
        JSONObject jsonObject;
        block2: {
            HashMap requestObject;
            block3: {
                jsonObject = new JSONObject();
                requestObject = (HashMap)fieldValue;
                if (requestObject.size() <= 0) break block2;
                if (memberDetail != null && (memberDetail == null || memberDetail.has("keys"))) break block3;
                for (Object key : requestObject.keySet()) {
                    jsonObject.put((String)key, this.redirectorForObjectToJSON(requestObject.get(key)));
                }
                break block2;
            }
            if (!memberDetail.has("keys")) break block2;
            JSONArray keysDetail = memberDetail.getJSONArray("keys");
            for (int keyIndex = 0; keyIndex < keysDetail.length(); ++keyIndex) {
                JSONObject keyDetail = keysDetail.getJSONObject(keyIndex);
                String keyName = keyDetail.getString("name");
                Object keyValue = null;
                if (!requestObject.containsKey(keyName) || requestObject.get(keyName) == null) continue;
                keyValue = this.setData(keyDetail, requestObject.get(keyName));
                jsonObject.put(keyName, keyValue);
            }
        }
        return jsonObject;
    }

    private JSONArray setJSONArray(Object fieldValue, JSONObject memberDetail) throws Exception {
        JSONArray jsonArray;
        block16: {
            jsonArray = new JSONArray();
            ArrayList requestObjects = (ArrayList)fieldValue;
            if (requestObjects.size() <= 0) break block16;
            if (memberDetail == null || memberDetail != null && !memberDetail.has("structure_name")) {
                if (memberDetail != null && memberDetail.has("sub_type")) {
                    JSONObject subType = memberDetail.getJSONObject("sub_type");
                    String type = subType.getString("type");
                    if (type.equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                        for (Object response : requestObjects) {
                            jsonArray.put(((Choice)response).getValue());
                        }
                    } else {
                        for (Object response : requestObjects) {
                            jsonArray.put(this.setDataValue(type, memberDetail, response));
                        }
                    }
                } else {
                    for (Object request : requestObjects) {
                        jsonArray.put(this.redirectorForObjectToJSON(request));
                    }
                }
            } else {
                String pack = memberDetail.getString("structure_name");
                if (pack.equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                    for (Object request : requestObjects) {
                        jsonArray.put(((Choice)request).getValue());
                    }
                } else if (memberDetail.has("module") && memberDetail.get("module") != null) {
                    int instanceCount = 0;
                    for (Object request : requestObjects) {
                        jsonArray.put((Object)this.isRecordRequest(request, this.getModuleDetailFromUserSpecJSON(memberDetail.getString("module")), instanceCount, memberDetail));
                        ++instanceCount;
                    }
                } else {
                    int instanceCount = 0;
                    for (Object request : requestObjects) {
                        jsonArray.put(this.formRequest(request, pack, instanceCount, memberDetail));
                        ++instanceCount;
                    }
                }
            }
        }
        return jsonArray;
    }

    private Object redirectorForObjectToJSON(Object request) throws Exception {
        if (request instanceof List) {
            return this.setJSONArray(request, null);
        }
        if (request instanceof Map) {
            return this.setJSONObject(request, null);
        }
        if (request.getClass().getCanonicalName().equals("com.zoho.crm.api.util.Choice")) {
            return ((Choice)request).getValue();
        }
        return request;
    }

    @Override
    public ArrayList<Object> getWrappedResponse(Object response, String pack) throws Exception {
        HttpEntity responseEntity = ((ClassicHttpResponse)response).getEntity();
        if (responseEntity != null) {
            String responseObject = EntityUtils.toString((HttpEntity)responseEntity);
            return new ArrayList<Object>(Arrays.asList(this.getResponse(responseObject, pack), this.getJSON(responseObject)));
        }
        return null;
    }

    private JSONObject getJSON(Object response) {
        String responseString = response.toString();
        if (responseString == null || responseString.equals("null") || responseString.isEmpty() || responseString.trim().length() == 0 || responseString.equals("{}")) {
            return null;
        }
        return new JSONObject(responseString);
    }

    @Override
    public Object getResponse(Object response, String packageName) throws Exception {
        JSONObject classDetail = Initializer.jsonDetails.getJSONObject(packageName);
        JSONObject responseJson = this.getJSON(response);
        if (responseJson == null) {
            return responseJson;
        }
        Object instance = null;
        if (classDetail.has("interface") && classDetail.getBoolean("interface")) {
            JSONArray classes = classDetail.getJSONArray("classes");
            instance = this.findMatch(classes, responseJson);
        } else {
            Constructor<?> constructor = Class.forName(packageName).getDeclaredConstructors()[0];
            if (Modifier.isPrivate(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            if ((instance = constructor.newInstance(new Object[0])) instanceof Record) {
                String moduleAPIName = this.commonAPIHandler.getModuleAPIName();
                instance = this.isRecordResponse(responseJson, classDetail, packageName);
                this.commonAPIHandler.setModuleAPIName(moduleAPIName);
            } else {
                instance = this.notRecordResponse(instance, responseJson, classDetail);
            }
        }
        return instance;
    }

    private Object notRecordResponse(Object instance, JSONObject responseJson, JSONObject classDetail) throws Exception {
        for (String memberName : classDetail.keySet()) {
            JSONObject keyDetail = classDetail.getJSONObject(memberName);
            String keyName = keyDetail.has("name") ? keyDetail.getString("name") : null;
            if (keyName == null || !responseJson.has(keyName) || responseJson.get(keyName) == null || responseJson.isNull(keyName)) continue;
            Object keyData = responseJson.get(keyName);
            Field member = instance.getClass().getDeclaredField(memberName);
            member.setAccessible(true);
            Object memberValue = this.getData(keyData, keyDetail);
            member.set(instance, memberValue);
        }
        return instance;
    }

    private Object isRecordResponse(JSONObject responseJson, JSONObject classDetail, String pack) throws JSONException, Exception {
        Object recordInstance = Class.forName(pack).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String moduleAPIName = this.commonAPIHandler.getModuleAPIName();
        JSONObject moduleDetail = new JSONObject();
        if (moduleAPIName != null) {
            this.commonAPIHandler.setModuleAPIName(null);
            moduleDetail = this.getModuleDetailFromUserSpecJSON(moduleAPIName);
        }
        for (String key : JSONObject.getNames((JSONObject)classDetail)) {
            if (moduleDetail == null) {
                moduleDetail = new JSONObject();
            }
            moduleDetail.put(key, classDetail.get(key));
        }
        JSONObject recordDetail = Initializer.jsonDetails.getJSONObject("com.zoho.crm.api.record.Record");
        Field member = null;
        Class<?> cl = recordInstance.getClass();
        Class<?> scl = cl.getSuperclass();
        if (scl.getCanonicalName().equals("com.zoho.crm.api.record.Record")) {
            cl = scl;
        }
        member = cl.getDeclaredField("keyValues");
        member.setAccessible(true);
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        for (String keyName : responseJson.keySet()) {
            String memberName = this.buildName(keyName);
            JSONObject keyDetail = new JSONObject();
            if (moduleDetail.length() > 0 && (moduleDetail.has(keyName) || moduleDetail.has(memberName))) {
                keyDetail = moduleDetail.has(keyName) ? moduleDetail.getJSONObject(keyName) : moduleDetail.getJSONObject(memberName);
            } else if (recordDetail.has(memberName)) {
                keyDetail = recordDetail.getJSONObject(memberName);
            }
            Object keyValue = null;
            Object keyData = responseJson.get(keyName);
            if (keyDetail.length() > 0) {
                keyName = keyDetail.getString("name");
                keyValue = this.getData(keyData, keyDetail);
            } else {
                keyValue = this.redirectorForJSONToObject(keyData);
            }
            keyValues.put(keyName, keyValue);
        }
        member.set(recordInstance, keyValues);
        return recordInstance;
    }

    private Object getData(Object keyData, JSONObject memberDetail) throws Exception {
        Object memberValue = null;
        if (keyData != JSONObject.NULL) {
            String type = (String)memberDetail.get("type");
            memberValue = this.getDataValue(type, keyData, memberDetail);
        }
        return memberValue;
    }

    private Object getDataValue(String type, Object keyData, JSONObject memberDetail) throws Exception {
        Object memberValue = null;
        memberValue = type.equalsIgnoreCase("java.util.List") ? this.getCollectionsData((JSONArray)keyData, memberDetail) : (type.equalsIgnoreCase("java.util.Map") ? this.getMapData((JSONObject)keyData, memberDetail) : (type.equals("com.zoho.crm.api.util.Choice") || memberDetail.has("structure_name") && memberDetail.getString("structure_name").equals("com.zoho.crm.api.util.Choice") ? Class.forName(type).getConstructors()[0].newInstance(keyData) : (memberDetail.has("structure_name") && memberDetail.has("module") ? this.isRecordResponse((JSONObject)keyData, this.getModuleDetailFromUserSpecJSON(memberDetail.getString("module")), memberDetail.getString("structure_name")) : (memberDetail.has("structure_name") ? this.getResponse(keyData, memberDetail.getString("structure_name")) : DataTypeConverter.preConvert(keyData, type)))));
        return memberValue;
    }

    private Map<String, Object> getMapData(JSONObject response, JSONObject memberDetail) throws Exception {
        HashMap<String, Object> mapInstance = new HashMap<String, Object>();
        if (response.length() > 0) {
            if (memberDetail == null || memberDetail != null && !memberDetail.has("keys")) {
                for (String key : response.keySet()) {
                    mapInstance.put(key, this.redirectorForJSONToObject(response.get(key)));
                }
            } else {
                Set responseKeys = response.keySet();
                if (memberDetail.has("keys")) {
                    JSONArray keysDetail = memberDetail.getJSONArray("keys");
                    for (int keyIndex = 0; keyIndex < keysDetail.length(); ++keyIndex) {
                        JSONObject keyDetail = keysDetail.getJSONObject(keyIndex);
                        String keyName = keyDetail.getString("name");
                        Object keyValue = null;
                        if (!response.has(keyName) || response.get(keyName) == null) continue;
                        keyValue = this.getData(response.get(keyName), keyDetail);
                        mapInstance.put(keyName, keyValue);
                        responseKeys.remove(keyName);
                    }
                }
                if (responseKeys.size() > 0) {
                    responseKeys.forEach(name -> mapInstance.put((String)name, response.get(name)));
                }
            }
        }
        return mapInstance;
    }

    private ArrayList<Object> getCollectionsData(JSONArray responses, JSONObject memberDetail) throws Exception {
        ArrayList<Object> values;
        block16: {
            values = new ArrayList<Object>();
            if (responses.length() <= 0) break block16;
            if (memberDetail == null || memberDetail != null && !memberDetail.has("structure_name")) {
                if (memberDetail != null && memberDetail.has("sub_type")) {
                    JSONObject subType = memberDetail.getJSONObject("sub_type");
                    String type = subType.getString("type");
                    if (type.equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                        for (Object response : responses) {
                            values.add(Class.forName("com.zoho.crm.api.util.Choice").getConstructors()[0].newInstance(response));
                        }
                    } else {
                        for (Object response : responses) {
                            values.add(this.getDataValue(type, response, memberDetail));
                        }
                    }
                } else {
                    for (Object response : responses) {
                        values.add(this.redirectorForJSONToObject(response));
                    }
                }
            } else {
                String pack = memberDetail.getString("structure_name");
                if (pack.equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                    for (Object response : responses) {
                        values.add(Class.forName("com.zoho.crm.api.util.Choice").getConstructors()[0].newInstance(response));
                    }
                } else if (memberDetail.has("module") && memberDetail.get("module") != null) {
                    for (Object response : responses) {
                        values.add(this.isRecordResponse((JSONObject)response, this.getModuleDetailFromUserSpecJSON(memberDetail.getString("module")), pack));
                    }
                } else {
                    for (Object response : responses) {
                        values.add(this.getResponse(response, pack));
                    }
                }
            }
        }
        return values;
    }

    private synchronized JSONObject getModuleDetailFromUserSpecJSON(String module) throws IOException, SDKException {
        String recordFieldDetailsPath = Initializer.getInitializer().getResourcePath() + File.separator + "resources" + File.separator + this.getEncodedFileName();
        JSONObject moduleDetailFromUserSpecJSON = Initializer.getJSON(recordFieldDetailsPath);
        return Utility.getJSONObject(moduleDetailFromUserSpecJSON, module);
    }

    private Object redirectorForJSONToObject(Object keyData) throws Exception {
        if (keyData instanceof JSONObject) {
            return this.getMapData((JSONObject)keyData, null);
        }
        if (keyData instanceof JSONArray) {
            return this.getCollectionsData((JSONArray)keyData, null);
        }
        if (keyData == JSONObject.NULL) {
            return null;
        }
        return keyData;
    }

    private Object findMatch(JSONArray classes, JSONObject responseJson) throws Exception {
        if (classes.length() == 1) {
            return this.getResponse(responseJson, classes.getString(0));
        }
        String pack = "";
        float ratio = 0.0f;
        for (Object className : classes) {
            float matchRatio = this.findRatio((String)className, responseJson);
            if ((double)matchRatio == 1.0) {
                pack = (String)className;
                ratio = 1.0f;
                break;
            }
            if (!(matchRatio > ratio)) continue;
            pack = (String)className;
            ratio = matchRatio;
        }
        return this.getResponse(responseJson, pack);
    }

    private float findRatio(String className, JSONObject responseJson) {
        JSONObject classDetail = (JSONObject)Initializer.jsonDetails.get(className);
        float totalPoints = classDetail.keySet().size();
        float matches = 0.0f;
        if (totalPoints == 0.0f) {
            return 0.0f;
        }
        block0: for (String memberName : classDetail.keySet()) {
            String structureName;
            JSONObject memberDetail = classDetail.getJSONObject(memberName);
            String keyName = memberDetail.has("name") ? memberDetail.getString("name") : null;
            if (keyName == null || !responseJson.has(keyName) || responseJson.get(keyName) == null) continue;
            Object keyData = responseJson.get(keyName);
            String type = keyData.getClass().getTypeName();
            String string = structureName = memberDetail.has("structure_name") ? memberDetail.getString("structure_name") : null;
            if (keyData instanceof JSONObject) {
                type = "java.util.Map";
            }
            if (keyData instanceof JSONArray) {
                type = "java.util.List";
            }
            if (type.equals(memberDetail.get("type"))) {
                matches += 1.0f;
            } else if (keyName.equalsIgnoreCase("count") && type.equalsIgnoreCase("java.lang.Integer")) {
                matches += 1.0f;
            } else if (memberDetail.getString("type").equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                for (Object value : memberDetail.getJSONArray("values")) {
                    if (!value.equals(keyData)) continue;
                    matches += 1.0f;
                    break;
                }
            }
            if (structureName == null || !structureName.equals(memberDetail.get("type"))) continue;
            if (memberDetail.has("values")) {
                for (Object value : memberDetail.getJSONArray("values")) {
                    if (!value.equals(keyData)) continue;
                    matches += 1.0f;
                    continue block0;
                }
                continue;
            }
            matches += 1.0f;
        }
        return matches / totalPoints;
    }

    public String buildName(String keyName) {
        int index;
        List<String> name = Arrays.asList(keyName.toLowerCase().split("_"));
        String sdkName = new String();
        if (name.isEmpty()) {
            boolean bl = true;
        }
        if (name.get(0) != null && name.get(0).length() != 0) {
            sdkName = name.get(0).substring(0, 1).toLowerCase().concat(name.get(0).substring(1));
        }
        for (int nameIndex = index = 1; nameIndex < name.size(); ++nameIndex) {
            String firstLetterUppercase = "";
            if (name.get(nameIndex).length() > 0) {
                firstLetterUppercase = name.get(nameIndex).substring(0, 1).toUpperCase().concat(name.get(nameIndex).substring(1));
            }
            sdkName = sdkName.concat(firstLetterUppercase);
        }
        return sdkName;
    }
}

