/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.util.Choice;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Converter;
import com.zoho.crm.api.util.DataTypeConverter;
import com.zoho.crm.api.util.JSONConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class HeaderParamValidator<T> {
    JSONObject jsonDetails = Initializer.jsonDetails;

    public String validate(String name, String className, T value) throws Exception {
        if (this.jsonDetails.has(className = this.getClassName(className))) {
            JSONObject classObject = this.jsonDetails.getJSONObject(className);
            for (String key : classObject.keySet()) {
                JSONObject memberDetail = classObject.getJSONObject(key);
                String keyName = memberDetail.getString("name");
                if (!name.equalsIgnoreCase(keyName)) continue;
                JSONConverter converter = new JSONConverter(new CommonAPIHandler());
                if (memberDetail.has("structure_name")) {
                    if (value instanceof Collection) {
                        JSONArray jsonArray = new JSONArray();
                        ArrayList requestObjects = (ArrayList)value;
                        if (!requestObjects.isEmpty()) {
                            for (Object requestObject : requestObjects) {
                                jsonArray.put(((Converter)converter).formRequest(requestObject, memberDetail.getString("structure_name"), null, null));
                            }
                        }
                        return jsonArray.toString();
                    }
                    return ((Converter)converter).formRequest(value, memberDetail.getString("structure_name"), null, null).toString();
                }
                if (memberDetail.has("type") && memberDetail.getString("type").equalsIgnoreCase("com.zoho.crm.api.util.Choice")) {
                    converter.checkChoiceValue("com.zoho.crm.api.util.Choice", memberDetail, value);
                }
                return this.parseData(value).toString();
            }
        }
        if (value instanceof Map || value instanceof Collection) {
            className = Object.class.getCanonicalName();
        }
        return DataTypeConverter.postConvert(value, className).toString();
    }

    public Object parseData(Object value) throws Exception {
        if (value instanceof Map) {
            JSONObject jsonObject = new JSONObject();
            HashMap requestObject = (HashMap)value;
            if (!requestObject.isEmpty()) {
                for (Object key : requestObject.keySet()) {
                    jsonObject.put((String)key, this.parseData(requestObject.get(key)));
                }
            }
            return jsonObject;
        }
        if (value instanceof Collection) {
            JSONArray jsonArray = new JSONArray();
            ArrayList requestObjects = (ArrayList)value;
            if (!requestObjects.isEmpty()) {
                for (Object requestObject : requestObjects) {
                    jsonArray.put(this.parseData(requestObject));
                }
            }
            return jsonArray;
        }
        if (value instanceof Choice) {
            return ((Choice)value).getValue();
        }
        return DataTypeConverter.postConvert(value, value.getClass().getName()).toString();
    }

    public String getClassName(String canonicalName) {
        if (canonicalName.contains(".")) {
            return canonicalName.substring(0, canonicalName.lastIndexOf(".")).toLowerCase() + canonicalName.substring(canonicalName.lastIndexOf("."));
        }
        return canonicalName;
    }
}

