/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataTypeConverter {
    private static final HashMap<String, PreConverter<?>> PRE_CONVERTER_MAP = new HashMap();
    private static final HashMap<String, PostConverter<?>> POST_CONVERTER_MAP = new HashMap();

    private static synchronized void init() {
        if (!PRE_CONVERTER_MAP.isEmpty() && !POST_CONVERTER_MAP.isEmpty()) {
            return;
        }
        DataTypeConverter.addToMap(LocalDate.class.getName(), obj -> {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return LocalDate.parse(obj.toString(), formatter);
        }, date -> date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        DataTypeConverter.addToMap(OffsetDateTime.class.getName(), obj -> OffsetDateTime.ofInstant(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(obj.toString())), ZoneId.systemDefault()), dateTime -> dateTime.withNano(0).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        DataTypeConverter.addToMap(String.class.getName(), obj -> obj.toString(), stringValue -> stringValue);
        DataTypeConverter.addToMap(Long.class.getName(), obj -> obj.toString().equalsIgnoreCase("null") ? null : Long.valueOf(Long.parseLong(obj.toString())), longValue -> longValue);
        DataTypeConverter.addToMap(Integer.class.getName(), obj -> Integer.parseInt(obj.toString()), integerValue -> integerValue);
        DataTypeConverter.addToMap(Boolean.class.getName(), obj -> Boolean.parseBoolean(obj.toString()), bool -> bool);
        DataTypeConverter.addToMap(Double.class.getName(), obj -> Double.parseDouble(obj.toString()), doubleValue -> doubleValue);
        DataTypeConverter.addToMap(Object.class.getName(), obj -> DataTypeConverter.preConvertObjectData(obj), objectValue -> DataTypeConverter.postConvertObjectData(objectValue));
        DataTypeConverter.addToMap(TimeZone.class.getName(), obj -> TimeZone.getTimeZone(obj.toString()), objectValue -> DataTypeConverter.postConvertObjectData(objectValue));
        DataTypeConverter.addToMap(LocalTime.class.getName(), obj -> LocalTime.parse(obj.toString()), objectValue -> DataTypeConverter.postConvertObjectData(objectValue));
    }

    private static Object preConvertObjectData(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            ArrayList<Object> values = new ArrayList<Object>();
            if (jsonArray.length() > 0) {
                for (Object response : jsonArray) {
                    values.add(DataTypeConverter.preConvertObjectData(response));
                }
            }
            return values;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            HashMap<String, Object> mapInstance = new HashMap<String, Object>();
            if (jsonObject.length() > 0) {
                for (String memberName : jsonObject.keySet()) {
                    Object jsonValue = jsonObject.get(memberName);
                    mapInstance.put(memberName, DataTypeConverter.preConvertObjectData(jsonValue));
                }
            }
            return mapInstance;
        }
        if (obj.getClass().getName().equalsIgnoreCase("Object")) {
            return obj;
        }
        return DataTypeConverter.preConvert(obj, obj.getClass().getName());
    }

    private static Object postConvertObjectData(Object obj) throws Exception {
        if (obj == null) {
            return JSONObject.NULL;
        }
        if (obj instanceof List) {
            JSONArray list = new JSONArray();
            for (Object value : (List)obj) {
                list.put(DataTypeConverter.postConvertObjectData(value));
            }
            return list;
        }
        if (obj instanceof Map) {
            JSONObject value = new JSONObject();
            HashMap requestObject = (HashMap)obj;
            if (requestObject.size() > 0) {
                for (Object key : requestObject.keySet()) {
                    Object keyValue = requestObject.get(key);
                    value.put((String)key, DataTypeConverter.postConvertObjectData(keyValue));
                }
            }
            return value;
        }
        if (obj instanceof TimeZone) {
            TimeZone timezone = (TimeZone)obj;
            return timezone.getID();
        }
        if (obj.getClass().getName().equalsIgnoreCase("Object")) {
            return obj;
        }
        return DataTypeConverter.postConvert(obj, obj.getClass().getName());
    }

    private static <R> void addToMap(String name, PreConverter<R> preConverter, PostConverter<R> postConverter) {
        PRE_CONVERTER_MAP.put(name, preConverter);
        POST_CONVERTER_MAP.put(name, postConverter);
    }

    public static <R> R preConvert(Object obj, String type) throws Exception {
        DataTypeConverter.init();
        if (PRE_CONVERTER_MAP.containsKey(type)) {
            return (R)PRE_CONVERTER_MAP.get(type).convert(obj);
        }
        return (R)obj;
    }

    public static <R> Object postConvert(R obj, String type) throws Exception {
        DataTypeConverter.init();
        if (POST_CONVERTER_MAP.containsKey(type)) {
            return POST_CONVERTER_MAP.get(type).convert(obj);
        }
        return obj;
    }

    private static interface PostConverter<R> {
        public Object convert(R var1) throws Exception;
    }

    private static interface PreConverter<R> {
        public R convert(Object var1) throws Exception;
    }
}

