/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Choice;
import com.zoho.crm.api.util.CommonAPIHandler;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Converter {
    protected CommonAPIHandler commonAPIHandler;

    public Converter() {
    }

    public Converter(CommonAPIHandler commonAPIHandler) {
        this.commonAPIHandler = commonAPIHandler;
    }

    public abstract Object getResponse(Object var1, String var2) throws Exception;

    public abstract Object formRequest(Object var1, String var2, Integer var3, JSONObject var4) throws Exception;

    public abstract void appendToRequest(ClassicHttpRequest var1, Object var2) throws Exception;

    public abstract ArrayList<Object> getWrappedResponse(Object var1, String var2) throws Exception;

    public boolean valueChecker(String className, String memberName, JSONObject keyDetails, Object value, HashMap<String, ArrayList<Object>> uniqueValuesMap, Integer instanceNumber) throws SDKException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JSONObject detailsJO = new JSONObject();
        String name = keyDetails.getString("name");
        Object type = keyDetails.getString("type");
        Object varType = null;
        Boolean check = true;
        if (value != null) {
            if (keyDetails.has("interface") && keyDetails.getBoolean("interface")) {
                JSONObject interfaceDetail = Initializer.jsonDetails.getJSONObject(keyDetails.getString("structure_name"));
                JSONArray classes = interfaceDetail.getJSONArray("classes");
                check = false;
                for (Object eachClass : classes) {
                    if (!value.getClass().getCanonicalName().equalsIgnoreCase(eachClass.toString())) continue;
                    check = true;
                    break;
                }
            } else {
                varType = value.getClass().getCanonicalName();
                check = ((String)varType).equalsIgnoreCase((String)type);
                if (!check.booleanValue() && value instanceof TimeZone && ((String)type).equalsIgnoreCase("java.util.TimeZone")) {
                    check = Boolean.TRUE;
                }
            }
        }
        if (value instanceof List) {
            Boolean expectedListType = true;
            if (keyDetails.has("structure_name")) {
                String structureName = keyDetails.getString("structure_name");
                int index = 0;
                List listValue = (List)value;
                for (Object data : listValue) {
                    className = data.getClass().getCanonicalName();
                    if (!className.equalsIgnoreCase(structureName)) {
                        instanceNumber = index;
                        type = "java.util.List(" + structureName + ")";
                        varType = "java.util.List(" + className + ")";
                        expectedListType = false;
                        check = false;
                        break;
                    }
                    ++index;
                }
            }
            if (expectedListType.booleanValue()) {
                check = ((String)varType).equalsIgnoreCase((String)type) ? true : ((String)varType).equalsIgnoreCase("java.util.ArrayList");
            }
        } else if (value instanceof Map) {
            check = ((String)varType).equalsIgnoreCase((String)type) ? true : ((String)varType).equalsIgnoreCase("java.util.HashMap");
        }
        if (!check.booleanValue() && !((String)type).equalsIgnoreCase("java.lang.Object")) {
            detailsJO.put("field", (Object)memberName);
            detailsJO.put("class", (Object)className);
            detailsJO.put("index", (Object)instanceNumber);
            detailsJO.put("expected-type", type);
            detailsJO.put("given-type", varType);
            throw new SDKException("TYPE ERROR", detailsJO);
        }
        if (keyDetails.has("values") && (!keyDetails.has("picklist") || keyDetails.getBoolean("picklist") && Initializer.getInitializer().getSDKConfig().getPickListValidation())) {
            JSONArray valuesJA = keyDetails.getJSONArray("values");
            List<String> pickListValue = IntStream.range(0, valuesJA.length()).mapToObj(arg_0 -> ((JSONArray)valuesJA).get(arg_0)).map(Object::toString).collect(Collectors.toList());
            this.checkChoiceValue(memberName, className, instanceNumber, valuesJA, value, detailsJO, pickListValue);
        }
        if (keyDetails.has("unique")) {
            ArrayList<Object> valuesArray = uniqueValuesMap.get(name);
            if (valuesArray != null && valuesArray.contains(value)) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("first-index", valuesArray.indexOf(value));
                detailsJO.put("next-index", (Object)instanceNumber);
                throw new SDKException("UNIQUE KEY ERROR", detailsJO);
            }
            if (valuesArray == null) {
                valuesArray = new ArrayList();
            }
            valuesArray.add(value);
            uniqueValuesMap.put(name, valuesArray);
        }
        if (keyDetails.has("min-length") || keyDetails.has("max-length")) {
            int count = value.toString().length();
            if (value instanceof List) {
                count = ((List)value).size();
            }
            if (keyDetails.has("max-length") && count > keyDetails.getInt("max-length")) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("given-length", count);
                detailsJO.put("maximum-length", keyDetails.getInt("max-length"));
                throw new SDKException("MAXIMUM LENGTH ERROR", detailsJO);
            }
            if (keyDetails.has("min-length") && count < keyDetails.getInt("min-length")) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("given-length", count);
                detailsJO.put("minimum-length", keyDetails.getInt("min-length"));
                throw new SDKException("MINIMUM LENGTH ERROR", detailsJO);
            }
        }
        return true;
    }

    public void checkChoiceValue(String className, JSONObject keyDetails, Object value) throws JSONException, SDKException {
        String name = keyDetails.optString("name");
        if (keyDetails.has("values") && name != null && Initializer.getInitializer().getSDKConfig().getPickListValidation()) {
            JSONArray valuesJA = keyDetails.getJSONArray("values");
            List<String> pickListValue = IntStream.range(0, valuesJA.length()).mapToObj(arg_0 -> ((JSONArray)valuesJA).get(arg_0)).map(Object::toString).collect(Collectors.toList());
            this.checkChoiceValue(name, className, 0, valuesJA, value, new JSONObject(), pickListValue);
        }
    }

    private void checkChoiceValue(String memberName, String className, Integer instanceNumber, JSONArray valuesJA, Object value, JSONObject detailsJO, List<String> pickListValue) throws SDKException {
        if (value instanceof List) {
            List value_1 = (List)value;
            for (Object value_2 : value_1) {
                if (value_2 instanceof Choice) {
                    Choice choice = (Choice)value_2;
                    value_2 = choice.getValue();
                }
                if (pickListValue.contains(value_2.toString())) continue;
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("index", (Object)instanceNumber);
                detailsJO.put("given-value", value);
                detailsJO.put("accepted-values", (Object)valuesJA);
                throw new SDKException("UNACCEPTED VALUES ERROR", detailsJO);
            }
        } else {
            if (value instanceof Choice) {
                Choice choice = (Choice)value;
                value = choice.getValue();
            }
            if (!pickListValue.contains(value.toString())) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("index", (Object)instanceNumber);
                detailsJO.put("given-value", value);
                detailsJO.put("accepted-values", (Object)valuesJA);
                throw new SDKException("UNACCEPTED VALUES ERROR", detailsJO);
            }
        }
    }

    public String getEncodedFileName() throws UnsupportedEncodingException, SDKException {
        Initializer initializer = Initializer.getInitializer();
        Token token = initializer.getToken();
        String accessToken = "";
        String refreshToken = "";
        String tokenKey = "";
        if (token instanceof OAuthToken) {
            OAuthToken oauthToken = (OAuthToken)token;
            if (oauthToken.getUserSignature() != null) {
                tokenKey = oauthToken.getUserSignature().getName();
            } else {
                refreshToken = oauthToken.getRefreshToken();
                if (refreshToken != null && refreshToken.length() > 0) {
                    tokenKey = refreshToken.substring(refreshToken.length() - 32);
                } else {
                    accessToken = oauthToken.getAccessToken();
                    if (accessToken != null && accessToken.length() > 0) {
                        tokenKey = accessToken.substring(accessToken.length() - 32);
                    }
                }
            }
        }
        Object fileName = initializer.getEnvironment().getUrl();
        if (tokenKey != null && tokenKey.length() > 0) {
            fileName = (String)fileName + tokenKey;
        }
        byte[] input = ((String)fileName).getBytes("UTF-8");
        String str = Base64.getEncoder().encodeToString(input);
        return str + ".json";
    }
}

