/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.usersterritories;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.usersterritories.ActionHandler;
import com.zoho.crm.api.usersterritories.BodyWrapper;
import com.zoho.crm.api.usersterritories.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;

public class UsersTerritoriesOperations {
    private Long user;

    public UsersTerritoriesOperations(Long user) {
        this.user = user;
    }

    public APIResponse<ResponseHandler> getTerritoriesOfUser() throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(this.user.toString());
        apiPath = apiPath.concat("/territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> associateTerritoriesToUser(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(this.user.toString());
        apiPath = apiPath.concat("/territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> removeTerritoriesFromUser(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(this.user.toString());
        apiPath = apiPath.concat("/territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getTerritoryOfUser(Long territory) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(this.user.toString());
        apiPath = apiPath.concat("/territories/");
        apiPath = apiPath.concat(territory.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> removeTerritoryFromUser(Long territory) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(this.user.toString());
        apiPath = apiPath.concat("/territories/");
        apiPath = apiPath.concat(territory.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class RemoveTerritoriesFromUserParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.UsersTerritories.RemoveTerritoriesFromUserParam");
    }
}

