/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.users;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.users.ActionHandler;
import com.zoho.crm.api.users.BodyWrapper;
import com.zoho.crm.api.users.CountHandler;
import com.zoho.crm.api.users.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import java.time.OffsetDateTime;

public class UsersOperations {
    public APIResponse<ResponseHandler> getUsers(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createUsers(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateUsers(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getUser(Long user, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(user.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateUser(Long user, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(user.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteUser(Long user) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(user.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getAssociatedGroups(Long user, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(user.toString());
        apiPath = apiPath.concat("/actions/associated_groups");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<CountHandler> usersCount(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/actions/count");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(CountHandler.class, "application/json");
    }

    public static class UsersCountParam {
        public static final Param<String> TYPE = new Param("type", "com.zoho.crm.api.Users.UsersCountParam");
    }

    public static class GetAssociatedGroupsParam {
        public static final Param<String> INCLUDE = new Param("include", "com.zoho.crm.api.Users.GetAssociatedGroupsParam");
    }

    public static class GetUserHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Users.GetUserHeader");
    }

    public static class GetUsersHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Users.GetUsersHeader");
    }

    public static class GetUsersParam {
        public static final Param<String> TYPE = new Param("type", "com.zoho.crm.api.Users.GetUsersParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Users.GetUsersParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Users.GetUsersParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.Users.GetUsersParam");
    }
}

