/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.usergroups;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.usergroups.ActionHandler;
import com.zoho.crm.api.usergroups.BodyWrapper;
import com.zoho.crm.api.usergroups.Criteria;
import com.zoho.crm.api.usergroups.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;

public class UserGroupsOperations {
    public APIResponse<ResponseHandler> getGroups(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createGroups(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateGroups(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getGroup(Long group) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateGroup(Long group, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteGroup(Long group) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getSources(Long group, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        apiPath = apiPath.concat("/sources");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("ACTION");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getSourcesCount(Long group) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        apiPath = apiPath.concat("/actions/sources_count");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("ACTION");
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getAssociations(Long group) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        apiPath = apiPath.concat("/actions/associations");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("ACTION");
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getAssociatedUsersCount(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/actions/associated_users_count");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("ACTION");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getAssociateGroupsOfUser(Long user, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/users/");
        apiPath = apiPath.concat(user.toString());
        apiPath = apiPath.concat("/actions/associated_groups");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getGroupedCounts(Long group, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/user_groups/");
        apiPath = apiPath.concat(group.toString());
        apiPath = apiPath.concat("/associated_users/actions/grouped_counts");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("ACTION");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public static class GetGroupedCountsParam {
        public static final Param<String> GROUP_BY = new Param("group_by", "com.zoho.crm.api.UserGroups.GetGroupedCountsParam");
    }

    public static class GetAssociateGroupsOfUserParam {
        public static final Param<String> INCLUDE = new Param("include", "com.zoho.crm.api.UserGroups.GetAssociateGroupsOfUserParam");
        public static final Param<String> PAGE = new Param("page", "com.zoho.crm.api.UserGroups.GetAssociateGroupsOfUserParam");
        public static final Param<String> PER_PAGE = new Param("per_page", "com.zoho.crm.api.UserGroups.GetAssociateGroupsOfUserParam");
    }

    public static class GetAssociatedUsersCountParam {
        public static final Param<String> PAGE = new Param("page", "com.zoho.crm.api.UserGroups.GetAssociatedUsersCountParam");
        public static final Param<String> PER_PAGE = new Param("per_page", "com.zoho.crm.api.UserGroups.GetAssociatedUsersCountParam");
        public static final Param<Criteria> FILTERS = new Param("filters", "com.zoho.crm.api.UserGroups.GetAssociatedUsersCountParam");
    }

    public static class GetSourcesParam {
        public static final Param<String> TYPE = new Param("type", "com.zoho.crm.api.UserGroups.GetSourcesParam");
        public static final Param<String> USER_TYPE = new Param("user_type", "com.zoho.crm.api.UserGroups.GetSourcesParam");
        public static final Param<String> PAGE = new Param("page", "com.zoho.crm.api.UserGroups.GetSourcesParam");
        public static final Param<String> PER_PAGE = new Param("per_page", "com.zoho.crm.api.UserGroups.GetSourcesParam");
    }

    public static class GetGroupsParam {
        public static final Param<String> INCLUDE = new Param("include", "com.zoho.crm.api.UserGroups.GetGroupsParam");
        public static final Param<String> NAME = new Param("name", "com.zoho.crm.api.UserGroups.GetGroupsParam");
        public static final Param<String> PAGE = new Param("page", "com.zoho.crm.api.UserGroups.GetGroupsParam");
        public static final Param<String> PER_PAGE = new Param("per_page", "com.zoho.crm.api.UserGroups.GetGroupsParam");
        public static final Param<Criteria> FILTERS = new Param("filters", "com.zoho.crm.api.UserGroups.GetGroupsParam");
    }
}

