/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.tags;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.tags.ActionHandler;
import com.zoho.crm.api.tags.BodyWrapper;
import com.zoho.crm.api.tags.ExistingTagRequestWrapper;
import com.zoho.crm.api.tags.MergeWrapper;
import com.zoho.crm.api.tags.NewTagRequestWrapper;
import com.zoho.crm.api.tags.RecordActionHandler;
import com.zoho.crm.api.tags.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;

public class TagsOperations {
    public APIResponse<ResponseHandler> getTags(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createTags(BodyWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateTags(BodyWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateTag(Long id, BodyWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteTag(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> mergeTags(Long id, MergeWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/merge");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<RecordActionHandler> addTags(String moduleAPIName, Long recordId, NewTagRequestWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/actions/add_tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(RecordActionHandler.class, "application/json");
    }

    public APIResponse<RecordActionHandler> removeTags(String moduleAPIName, Long recordId, ExistingTagRequestWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/actions/remove_tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(RecordActionHandler.class, "application/json");
    }

    public APIResponse<RecordActionHandler> addTagsToMultipleRecords(String moduleAPIName, NewTagRequestWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/add_tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(RecordActionHandler.class, "application/json");
    }

    public APIResponse<RecordActionHandler> removeTagsFromMultipleRecords(String moduleAPIName, ExistingTagRequestWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/remove_tags");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(RecordActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRecordCountForTag(Long id, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/tags/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/records_count");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public static class GetRecordCountForTagParam {
        public static final Param<String> MODULE = new Param("module", "com.zoho.crm.api.Tags.GetRecordCountForTagParam");
    }

    public static class RemoveTagsFromMultipleRecordsParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.Tags.RemoveTagsFromMultipleRecordsParam");
    }

    public static class AddTagsToMultipleRecordsParam {
        public static final Param<String> OVER_WRITE = new Param("over_write", "com.zoho.crm.api.Tags.AddTagsToMultipleRecordsParam");
    }

    public static class AddTagsParam {
        public static final Param<String> OVER_WRITE = new Param("over_write", "com.zoho.crm.api.Tags.AddTagsParam");
    }

    public static class UpdateTagParam {
        public static final Param<String> MODULE = new Param("module", "com.zoho.crm.api.Tags.UpdateTagParam");
    }

    public static class UpdateTagsParam {
        public static final Param<String> MODULE = new Param("module", "com.zoho.crm.api.Tags.UpdateTagsParam");
    }

    public static class CreateTagsParam {
        public static final Param<String> MODULE = new Param("module", "com.zoho.crm.api.Tags.CreateTagsParam");
        public static final Param<String> COLOR_CODE = new Param("color_code", "com.zoho.crm.api.Tags.CreateTagsParam");
    }

    public static class GetTagsParam {
        public static final Param<String> MODULE = new Param("module", "com.zoho.crm.api.Tags.GetTagsParam");
        public static final Param<String> MY_TAGS = new Param("my_tags", "com.zoho.crm.api.Tags.GetTagsParam");
        public static final Param<String> INCLUDE = new Param("include", "com.zoho.crm.api.Tags.GetTagsParam");
    }
}

