/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.relatedrecords;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.relatedrecords.ActionHandler;
import com.zoho.crm.api.relatedrecords.BodyWrapper;
import com.zoho.crm.api.relatedrecords.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Utility;
import java.time.OffsetDateTime;

public class RelatedRecordsOperations {
    private String moduleAPIName;
    private String relatedListAPIName;

    public RelatedRecordsOperations(String relatedListAPIName, String moduleAPIName) {
        this.relatedListAPIName = relatedListAPIName;
        this.moduleAPIName = moduleAPIName;
    }

    public APIResponse<ResponseHandler> getRelatedRecords(Long recordId, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecords(Long recordId, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> delinkRecords(Long recordId, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRelatedRecordsUsingExternalId(String externalValue, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecordsUsingExternalId(String externalValue, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteRelatedRecordsUsingExternalId(String externalValue, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRelatedRecord(Long relatedRecordId, Long recordId, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecord(Long relatedRecordId, Long recordId, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> delinkRecord(Long relatedRecordId, Long recordId, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRelatedRecordUsingExternalId(String externalFieldValue, String externalValue, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecordUsingExternalId(String externalFieldValue, String externalValue, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteRelatedRecordUsingExternalId(String externalFieldValue, String externalValue, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalValue.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getDeletedParentRecordsRelatedRecord(Long recordId, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/deleted/");
        apiPath = apiPath.concat(recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public static class GetDeletedParentRecordsRelatedRecordParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RelatedRecords.GetDeletedParentRecordsRelatedRecordParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.RelatedRecords.GetDeletedParentRecordsRelatedRecordParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.RelatedRecords.GetDeletedParentRecordsRelatedRecordParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.GetDeletedParentRecordsRelatedRecordParam");
    }

    public static class DeleteRelatedRecordUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.DeleteRelatedRecordUsingExternalIDHeader");
    }

    public static class UpdateRelatedRecordUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.UpdateRelatedRecordUsingExternalIDHeader");
    }

    public static class GetRelatedRecordUsingExternalIDHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordUsingExternalIDHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordUsingExternalIDHeader");
    }

    public static class GetRelatedRecordUsingExternalIDParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordUsingExternalIDParam");
    }

    public static class DelinkRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.DelinkRecordHeader");
    }

    public static class UpdateRelatedRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.UpdateRelatedRecordHeader");
    }

    public static class GetRelatedRecordHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordHeader");
    }

    public static class GetRelatedRecordParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordParam");
    }

    public static class DeleteRelatedRecordsUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.DeleteRelatedRecordsUsingExternalIDHeader");
    }

    public static class DeleteRelatedRecordsUsingExternalIDParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.DeleteRelatedRecordsUsingExternalIDParam");
    }

    public static class UpdateRelatedRecordsUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.UpdateRelatedRecordsUsingExternalIDHeader");
    }

    public static class GetRelatedRecordsUsingExternalIDHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDHeader");
    }

    public static class GetRelatedRecordsUsingExternalIDParam {
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsUsingExternalIDParam");
    }

    public static class DelinkRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.DelinkRecordsHeader");
    }

    public static class DelinkRecordsParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.DelinkRecordsParam");
    }

    public static class UpdateRelatedRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.UpdateRelatedRecordsHeader");
    }

    public static class GetRelatedRecordsHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsHeader");
    }

    public static class GetRelatedRecordsParam {
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
    }
}

