/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.recordlocking;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.recordlocking.ActionHandler;
import com.zoho.crm.api.recordlocking.BodyWrapper;
import com.zoho.crm.api.recordlocking.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Utility;

public class RecordLockingOperations {
    private String moduleName;
    private Long recordId;

    public RecordLockingOperations(Long recordId, String moduleName) {
        this.recordId = recordId;
        this.moduleName = moduleName;
    }

    public APIResponse<ResponseHandler> getRecordLockingInformations(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Locking_Information__s");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setModuleAPIName("Locking_Information__s");
        Utility.getFields("Locking_Information__s", handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> lockRecords(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Locking_Information__s");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName("Locking_Information__s");
        Utility.getFields("Locking_Information__s", handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRecordLockingInformation(Long lockId, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Locking_Information__s/");
        apiPath = apiPath.concat(lockId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setModuleAPIName("Locking_Information__s");
        Utility.getFields("Locking_Information__s", handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRecordLockingInformation(Long lockId, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Locking_Information__s/");
        apiPath = apiPath.concat(lockId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName("Locking_Information__s");
        Utility.getFields("Locking_Information__s", handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> unlockRecord(Long lockId) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Locking_Information__s/");
        apiPath = apiPath.concat(lockId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setModuleAPIName("Locking_Information__s");
        Utility.getFields("Locking_Information__s", handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class GetRecordLockingInformationParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationParam");
    }

    public static class GetRecordLockingInformationsParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationsParam");
        public static final Param<String> PAGE_TOKEN = new Param("page_token", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationsParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationsParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.RecordLocking.GetRecordLockingInformationsParam");
    }
}

