/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.record;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.ActionHandler;
import com.zoho.crm.api.record.BodyWrapper;
import com.zoho.crm.api.record.CountHandler;
import com.zoho.crm.api.record.DeletedRecordsHandler;
import com.zoho.crm.api.record.DownloadHandler;
import com.zoho.crm.api.record.FileBodyWrapper;
import com.zoho.crm.api.record.FileHandler;
import com.zoho.crm.api.record.MassUpdateActionHandler;
import com.zoho.crm.api.record.MassUpdateBodyWrapper;
import com.zoho.crm.api.record.MassUpdateResponseHandler;
import com.zoho.crm.api.record.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Utility;
import java.time.OffsetDateTime;

public class RecordOperations {
    private String moduleAPIName;

    public RecordOperations(String moduleAPIName) {
        this.moduleAPIName = moduleAPIName;
    }

    public APIResponse<ResponseHandler> getRecord(Long id, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRecord(Long id, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteRecord(Long id, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRecords(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createRecords(BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRecords(BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteRecords(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> upsertRecords(BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/upsert");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("ACTION");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<DeletedRecordsHandler> getDeletedRecords(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/deleted");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(DeletedRecordsHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> searchRecords(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/search");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<DownloadHandler> getPhoto(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/photo");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(DownloadHandler.class, "application/x-download");
    }

    public APIResponse<FileHandler> uploadPhoto(Long id, FileBodyWrapper request, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/photo");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("multipart/form-data");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        Utility.verifyPhotoSupport(this.moduleAPIName);
        return handlerInstance.apiCall(FileHandler.class, "application/json");
    }

    public APIResponse<FileHandler> deletePhoto(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/photo");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(FileHandler.class, "application/json");
    }

    public APIResponse<MassUpdateActionHandler> massUpdateRecords(MassUpdateBodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/mass_update");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(MassUpdateActionHandler.class, "application/json");
    }

    public APIResponse<MassUpdateResponseHandler> getMassUpdateStatus(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/mass_update");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(MassUpdateResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> assignTerritoriesToMultipleRecords(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/assign_territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> assignTerritoryToRecord(Long id, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/assign_territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> removeTerritoriesFromMultipleRecords(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/remove_territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> removeTerritoriesFromRecord(Long id, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/remove_territories");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<CountHandler> recordCount(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/count");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(CountHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRecordUsingExternalId(String externalFieldValue, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRecordUsingExternalId(String externalFieldValue, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setHeader(headerInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteRecordUsingExternalId(String externalFieldValue, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(externalFieldValue.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getFullDataForRichText(Long id, ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/fetch_full_data");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRichTextRecords(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/actions/fetch_full_data");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> cloneRecord(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(id.toString());
        apiPath = apiPath.concat("/actions/clone");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setModuleAPIName(this.moduleAPIName);
        Utility.getFields(this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class GetRichTextRecordsParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.Record.GetRichTextRecordsParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.GetRichTextRecordsParam");
    }

    public static class GetFullDataForRichTextParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.GetFullDataForRichTextParam");
    }

    public static class DeleteRecordUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.DeleteRecordUsingExternalIDHeader");
    }

    public static class DeleteRecordUsingExternalIDParam {
        public static final Param<Boolean> WF_TRIGGER = new Param("wf_trigger", "com.zoho.crm.api.Record.DeleteRecordUsingExternalIDParam");
    }

    public static class UpdateRecordUsingExternalIDHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.UpdateRecordUsingExternalIDHeader");
    }

    public static class GetRecordUsingExternalIDHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Record.GetRecordUsingExternalIDHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.GetRecordUsingExternalIDHeader");
    }

    public static class GetRecordUsingExternalIDParam {
        public static final Param<String> APPROVED = new Param("approved", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> CONVERTED = new Param("converted", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> CVID = new Param("cvid", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> UID = new Param("uid", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<OffsetDateTime> STARTDATETIME = new Param("startDateTime", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<OffsetDateTime> ENDDATETIME = new Param("endDateTime", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> TERRITORY_ID = new Param("territory_id", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
        public static final Param<String> INCLUDE_CHILD = new Param("include_child", "com.zoho.crm.api.Record.GetRecordUsingExternalIDParam");
    }

    public static class RecordCountParam {
        public static final Param<String> CVID = new Param("cvid", "com.zoho.crm.api.Record.RecordCountParam");
        public static final Param<String> CRITERIA = new Param("criteria", "com.zoho.crm.api.Record.RecordCountParam");
        public static final Param<String> EMAIL = new Param("email", "com.zoho.crm.api.Record.RecordCountParam");
        public static final Param<String> PHONE = new Param("phone", "com.zoho.crm.api.Record.RecordCountParam");
        public static final Param<String> WORD = new Param("word", "com.zoho.crm.api.Record.RecordCountParam");
    }

    public static class GetMassUpdateStatusParam {
        public static final Param<String> JOB_ID = new Param("job_id", "com.zoho.crm.api.Record.GetMassUpdateStatusParam");
    }

    public static class UploadPhotoParam {
        public static final Param<String> RESTRICT_TRIGGERS = new Param("restrict_triggers", "com.zoho.crm.api.Record.UploadPhotoParam");
    }

    public static class SearchRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.SearchRecordsHeader");
    }

    public static class SearchRecordsParam {
        public static final Param<String> CRITERIA = new Param("criteria", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> EMAIL = new Param("email", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> PHONE = new Param("phone", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> WORD = new Param("word", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> CONVERTED = new Param("converted", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> APPROVED = new Param("approved", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> CVID = new Param("cvid", "com.zoho.crm.api.Record.SearchRecordsParam");
        public static final Param<String> TYPE = new Param("type", "com.zoho.crm.api.Record.SearchRecordsParam");
    }

    public static class GetDeletedRecordsHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Record.GetDeletedRecordsHeader");
    }

    public static class GetDeletedRecordsParam {
        public static final Param<String> TYPE = new Param("type", "com.zoho.crm.api.Record.GetDeletedRecordsParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Record.GetDeletedRecordsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Record.GetDeletedRecordsParam");
    }

    public static class UpsertRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.UpsertRecordsHeader");
    }

    public static class DeleteRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.DeleteRecordsHeader");
    }

    public static class DeleteRecordsParam {
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.Record.DeleteRecordsParam");
        public static final Param<Boolean> WF_TRIGGER = new Param("wf_trigger", "com.zoho.crm.api.Record.DeleteRecordsParam");
    }

    public static class UpdateRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.UpdateRecordsHeader");
    }

    public static class CreateRecordsHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.CreateRecordsHeader");
    }

    public static class GetRecordsHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Record.GetRecordsHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.GetRecordsHeader");
    }

    public static class GetRecordsParam {
        public static final Param<String> APPROVED = new Param("approved", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> CONVERTED = new Param("converted", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> CVID = new Param("cvid", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> IDS = new Param("ids", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> UID = new Param("uid", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> SORT_BY = new Param("sort_by", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> SORT_ORDER = new Param("sort_order", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<OffsetDateTime> STARTDATETIME = new Param("startDateTime", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<OffsetDateTime> ENDDATETIME = new Param("endDateTime", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> TERRITORY_ID = new Param("territory_id", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> INCLUDE_CHILD = new Param("include_child", "com.zoho.crm.api.Record.GetRecordsParam");
        public static final Param<String> PAGE_TOKEN = new Param("page_token", "com.zoho.crm.api.Record.GetRecordsParam");
    }

    public static class DeleteRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.DeleteRecordHeader");
    }

    public static class DeleteRecordParam {
        public static final Param<Boolean> WF_TRIGGER = new Param("wf_trigger", "com.zoho.crm.api.Record.DeleteRecordParam");
    }

    public static class UpdateRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.UpdateRecordHeader");
    }

    public static class GetRecordHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Record.GetRecordHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.Record.GetRecordHeader");
    }

    public static class GetRecordParam {
        public static final Param<String> APPROVED = new Param("approved", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> CONVERTED = new Param("converted", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> CVID = new Param("cvid", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> UID = new Param("uid", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<OffsetDateTime> STARTDATETIME = new Param("startDateTime", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<OffsetDateTime> ENDDATETIME = new Param("endDateTime", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> TERRITORY_ID = new Param("territory_id", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> INCLUDE_CHILD = new Param("include_child", "com.zoho.crm.api.Record.GetRecordParam");
        public static final Param<String> ON_DEMAND_PROPERTIES = new Param("on_demand_properties", "com.zoho.crm.api.Record.GetRecordParam");
    }
}

