/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.holidays;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.holidays.ActionHandler;
import com.zoho.crm.api.holidays.BodyWrapper;
import com.zoho.crm.api.holidays.Holidays;
import com.zoho.crm.api.holidays.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.Choice;
import com.zoho.crm.api.util.CommonAPIHandler;

public class HolidaysOperations {
    private String xCrmOrg;

    public HolidaysOperations(String xCrmOrg) {
        this.xCrmOrg = xCrmOrg;
    }

    public APIResponse<ResponseHandler> getHolidays(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.GetHolidaysHeader"), this.xCrmOrg);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createHolidays(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.CreateHolidaysHeader"), this.xCrmOrg);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateHolidays(Holidays request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.UpdateHolidaysHeader"), this.xCrmOrg);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateHoliday(Long holidayId, Holidays request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays/");
        apiPath = apiPath.concat(holidayId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.UpdateHolidayHeader"), this.xCrmOrg);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getHoliday(Long holidayId) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays/");
        apiPath = apiPath.concat(holidayId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.GetHolidayHeader"), this.xCrmOrg);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteHoliday(Long holidayId) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/settings/holidays/");
        apiPath = apiPath.concat(holidayId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.addHeader(new Header("X-CRM-ORG", "com.zoho.crm.api.Holidays.DeleteHolidayHeader"), this.xCrmOrg);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class DeleteHolidayHeader {
    }

    public static class GetHolidayHeader {
    }

    public static class UpdateHolidayHeader {
    }

    public static class UpdateHolidaysHeader {
    }

    public static class CreateHolidaysHeader {
    }

    public static class GetHolidaysParam {
        public static final Param<Integer> YEAR = new Param("year", "com.zoho.crm.api.Holidays.GetHolidaysParam");
        public static final Param<Choice<String>> TYPE = new Param("type", "com.zoho.crm.api.Holidays.GetHolidaysParam");
        public static final Param<Long> SHIFT_ID = new Param("shift_id", "com.zoho.crm.api.Holidays.GetHolidaysParam");
    }

    public static class GetHolidaysHeader {
    }
}

