/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.functions;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.functions.BodyWrapper;
import com.zoho.crm.api.functions.FileBodyWrapper;
import com.zoho.crm.api.functions.ResponseWrapper;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import java.util.Map;

public class FunctionsOperations {
    private String authType;
    private String functionName;
    private Map<String, Object> arguments;

    public FunctionsOperations(String functionName, String authType, Map<String, Object> arguments) {
        this.functionName = functionName;
        this.authType = authType;
        this.arguments = arguments;
    }

    public APIResponse<ResponseWrapper> executeFunctionUsingRequestBody(BodyWrapper request, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/functions/");
        apiPath = apiPath.concat(this.functionName.toString());
        apiPath = apiPath.concat("/actions/execute");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.addParam(new Param("auth_type", "com.zoho.crm.api.Functions.ExecuteFunctionUsingRequestBodyParam"), this.authType);
        handlerInstance.addParam(new Param("arguments", "com.zoho.crm.api.Functions.ExecuteFunctionUsingRequestBodyParam"), this.arguments);
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseWrapper.class, "application/json");
    }

    public APIResponse<ResponseWrapper> executeFunctionUsingParameters(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/functions/");
        apiPath = apiPath.concat(this.functionName.toString());
        apiPath = apiPath.concat("/actions/execute");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.addParam(new Param("auth_type", "com.zoho.crm.api.Functions.ExecuteFunctionUsingParametersParam"), this.authType);
        handlerInstance.addParam(new Param("arguments", "com.zoho.crm.api.Functions.ExecuteFunctionUsingParametersParam"), this.arguments);
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseWrapper.class, "application/json");
    }

    public APIResponse<ResponseWrapper> executeFunctionUsingFile(FileBodyWrapper request, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v8/functions/");
        apiPath = apiPath.concat(this.functionName.toString());
        apiPath = apiPath.concat("/actions/execute");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("multipart/form-data");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.addParam(new Param("auth_type", "com.zoho.crm.api.Functions.ExecuteFunctionUsingFileParam"), this.authType);
        handlerInstance.addParam(new Param("arguments", "com.zoho.crm.api.Functions.ExecuteFunctionUsingFileParam"), this.arguments);
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseWrapper.class, "application/json");
    }

    public static class ExecuteFunctionUsingFileHeader {
        public static final Header<Map<String, Object>> UPLOAD_FILE_HEADER = new Header("upload_file_header", "com.zoho.crm.api.Functions.ExecuteFunctionUsingFileHeader");
    }

    public static class ExecuteFunctionUsingFileParam {
        public static final Param<Map<String, Object>> UPLOAD_FILE_PARAM = new Param("upload_file_param", "com.zoho.crm.api.Functions.ExecuteFunctionUsingFileParam");
    }

    public static class ExecuteFunctionUsingParametersHeader {
        public static final Header<Map<String, Object>> GET_CUSTOM_FUNCTIONS_HEADER = new Header("get_custom_functions_header", "com.zoho.crm.api.Functions.ExecuteFunctionUsingParametersHeader");
    }

    public static class ExecuteFunctionUsingParametersParam {
        public static final Param<Map<String, Object>> GET_CUSTOM_FUNCTIONS_PARAM = new Param("get_custom_functions_param", "com.zoho.crm.api.Functions.ExecuteFunctionUsingParametersParam");
    }

    public static class ExecuteFunctionUsingRequestBodyHeader {
        public static final Header<Map<String, Object>> CUSTOM_FUNCTIONS_HEADER = new Header("custom_functions_header", "com.zoho.crm.api.Functions.ExecuteFunctionUsingRequestBodyHeader");
    }

    public static class ExecuteFunctionUsingRequestBodyParam {
        public static final Param<Map<String, Object>> CUSTOM_FUNCTIONS_PARAM = new Param("custom_functions_param", "com.zoho.crm.api.Functions.ExecuteFunctionUsingRequestBodyParam");
    }
}

