/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.DataTypeConverter;
import com.zoho.crm.api.util.HeaderParamValidator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParameterMap {
    protected static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private HashMap<String, String> parameterMap = new HashMap();

    public HashMap<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public <T> void add(Param<T> param, T value) throws SDKException {
        if (param == null) {
            throw new SDKException("NULL PARAMETER ERROR", "Param Instance MUST NOT be null");
        }
        String paramName = param.getName();
        if (paramName == null) {
            throw new SDKException("NULL PARAM NAME ERROR", "Param Name MUST NOT be null");
        }
        if (value == null) {
            throw new SDKException("NULL PARAMETER ERROR", paramName + " MUST NOT be null");
        }
        try {
            String parsedParamValue;
            String paramClassName = param.getClassName();
            if (paramClassName != null) {
                HeaderParamValidator<T> headerParamValidator = new HeaderParamValidator<T>();
                parsedParamValue = headerParamValidator.validate(paramName, paramClassName, value);
            } else {
                try {
                    parsedParamValue = DataTypeConverter.postConvert(value, value.getClass().getName()).toString();
                }
                catch (Exception e) {
                    parsedParamValue = value.toString();
                }
            }
            if (this.parameterMap.containsKey(paramName) && !this.parameterMap.get(paramName).isEmpty()) {
                Object existingParamValue = this.parameterMap.get(paramName);
                existingParamValue = (String)existingParamValue + "," + parsedParamValue;
                this.parameterMap.put(paramName, (String)existingParamValue);
            } else {
                this.parameterMap.put(paramName, parsedParamValue);
            }
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in forming request Parameter : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in forming request Parameter : ", exception);
            throw exception;
        }
    }
}

