/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Header;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.DataTypeConverter;
import com.zoho.crm.api.util.HeaderParamValidator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeaderMap {
    protected static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private HashMap<String, String> headerMap = new HashMap();

    public HashMap<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public <T> void add(Header<T> header, T value) throws SDKException {
        if (header == null) {
            throw new SDKException("NULL HEADER ERROR", "Header Instance MUST NOT be null");
        }
        String headerName = header.getName();
        if (headerName == null) {
            throw new SDKException("NULL HEADER NAME ERROR", "Header Name MUST NOT be null");
        }
        if (value == null) {
            throw new SDKException("NULL HEADER ERROR", headerName + " MUST NOT be null");
        }
        try {
            String parsedHeaderValue;
            String headerClassName = header.getClassName();
            if (headerClassName != null) {
                HeaderParamValidator<T> headerParamValidator = new HeaderParamValidator<T>();
                parsedHeaderValue = headerParamValidator.validate(headerName, headerClassName, value);
            } else {
                try {
                    parsedHeaderValue = DataTypeConverter.postConvert(value, value.getClass().getName()).toString();
                }
                catch (Exception e) {
                    parsedHeaderValue = value.toString();
                }
            }
            if (this.headerMap.containsKey(headerName) && !this.headerMap.get(headerName).isEmpty()) {
                Object existingHeaderValue = this.headerMap.get(headerName);
                existingHeaderValue = (String)existingHeaderValue + "," + parsedHeaderValue;
                this.headerMap.put(headerName, (String)existingHeaderValue);
            } else {
                this.headerMap.put(headerName, parsedHeaderValue);
            }
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in forming request Header : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in forming request Header : ", exception);
            throw exception;
        }
    }
}

