/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FileStore
implements TokenStore {
    private String filePath;
    private String[] headers;

    public FileStore(String filePath) throws Exception {
        block23: {
            this.headers = new String[]{"id", "user_name", "client_id", "client_secret", "refresh_token", "access_token", "grant_token", "expiry_time", "redirect_url", "api_domain"};
            this.filePath = filePath;
            boolean isCreate = false;
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), true));
                 FileReader fileReader = new FileReader(this.filePath);){
                if (fileReader.read() == -1) {
                    isCreate = true;
                    csvWriter.writeNext(this.headers, false);
                }
                csvWriter.flush();
            }
            if (!isCreate) {
                try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
                    List allContents = csvReader.readAll();
                    String[] headers = (String[])allContents.get(0);
                    if (headers.length != 9) break block23;
                    allContents = allContents.stream().map(arr -> Arrays.copyOf(arr, ((String[])arr).length + 1)).collect(Collectors.toList());
                    allContents.set(0, this.headers);
                    try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath)));){
                        csvWriter.writeAll(allContents, false);
                        csvWriter.flush();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token findToken(Token token) throws SDKException {
        if (!(token instanceof OAuthToken)) {
            return token;
        }
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            OAuthToken oauthToken = (OAuthToken)token;
            List allContents = csvReader.readAll().stream().filter(row -> ((String[])row).length > 1).collect(Collectors.toList());
            Boolean isRowPresent = Boolean.FALSE;
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                if (nextRecord.length <= 1 || !(isRowPresent = this.checkCondition(oauthToken, nextRecord)).booleanValue()) continue;
                this.setMergeData(oauthToken, nextRecord);
                OAuthToken oAuthToken = oauthToken;
                return oAuthToken;
            }
            if (isRowPresent != false) return token;
            Token token2 = null;
            return token2;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in FileStore : Given user authentication details not found.", ex);
        }
    }

    @Override
    public void saveToken(Token token) throws SDKException {
        if (!(token instanceof OAuthToken)) {
            return;
        }
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            Boolean isRowPresent = Boolean.FALSE;
            OAuthToken oauthToken = (OAuthToken)token;
            List<String[]> allContents = csvReader.readAll().stream().filter(row -> ((String[])row).length > 1).collect(Collectors.toList());
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                if (nextRecord.length > 1) {
                    if (oauthToken.getId() != null) {
                        String id = this.getData(nextRecord[0]);
                        if (id != null && oauthToken.getId() != null && id.equals(oauthToken.getId())) {
                            isRowPresent = Boolean.TRUE;
                        }
                    } else {
                        isRowPresent = this.checkCondition(oauthToken, nextRecord);
                    }
                    if (!isRowPresent.booleanValue()) continue;
                    this.setMergeData(oauthToken, nextRecord);
                    allContents.set(index, this.setToken(oauthToken));
                    break;
                }
                allContents.remove(index);
            }
            if (!isRowPresent.booleanValue()) {
                if ((oauthToken.getId() != null || oauthToken.getUserSignature() != null) && oauthToken.getRefreshToken() == null && oauthToken.getGrantToken() == null && oauthToken.getAccessToken() == null) {
                    throw new SDKException("TOKEN_STORE", "Exception in FileStore : Given user authentication details not found.");
                }
                if (oauthToken.getId() == null) {
                    String newId = this.generateId(allContents);
                    oauthToken.setId(newId);
                }
                allContents.add(this.setToken(oauthToken));
            }
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath)));){
                csvWriter.writeAll(allContents, false);
            }
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in saveToken - FileStore : ", ex);
        }
    }

    @Override
    public void deleteToken(String id) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(new File(this.filePath)));){
            Boolean isRowPresent = Boolean.FALSE;
            List allContents = csvReader.readAll().stream().filter(row -> ((String[])row).length > 1).collect(Collectors.toList());
            for (int index = 1; index < allContents.size(); ++index) {
                String recordId;
                String[] nextRecord = (String[])allContents.get(index);
                if (nextRecord.length <= 1 || (recordId = this.getData(nextRecord[0])) == null || !recordId.equals(id)) continue;
                isRowPresent = Boolean.TRUE;
                allContents.remove(index);
                break;
            }
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath)));){
                csvWriter.writeAll(allContents, false);
            }
            if (!isRowPresent.booleanValue()) {
                throw new SDKException("TOKEN_STORE", "Exception in FileStore : Given Id not found");
            }
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteToken - FileStore : ", ex);
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            List allContents = csvReader.readAll();
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                if (nextRecord.length <= 1) continue;
                OAuthToken oauthToken = new OAuthToken();
                this.setMergeData(oauthToken, nextRecord);
                tokens.add(oauthToken);
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - FileStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), false));){
            csvWriter.writeNext(this.headers, false);
            csvWriter.flush();
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - FileStore : ", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token findTokenById(String id) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            OAuthToken oauthToken = new OAuthToken();
            List allContents = csvReader.readAll().stream().filter(row -> ((String[])row).length > 1).collect(Collectors.toList());
            Boolean isRowPresent = Boolean.FALSE;
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                if (!nextRecord[0].equals(id)) continue;
                isRowPresent = Boolean.TRUE;
                this.setMergeData(oauthToken, nextRecord);
                OAuthToken oAuthToken = oauthToken;
                return oAuthToken;
            }
            if (isRowPresent != false) return null;
            throw new SDKException("TOKEN_STORE", "Exception in FileStore : Given Id not found");
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in FileStore : Given Id not found", ex);
        }
    }

    private Boolean checkCondition(OAuthToken oauthToken, String[] nextRecord) {
        Boolean isRowPresent = Boolean.FALSE;
        if (oauthToken.getUserSignature() != null) {
            String name = oauthToken.getUserSignature().getName();
            String userName = this.getData(nextRecord[1]);
            if (name != null && name.length() > 0 && userName != null && userName.length() > 0 && name.equals(userName)) {
                isRowPresent = Boolean.TRUE;
            }
        } else if (oauthToken.getAccessToken() != null && this.areAllObjectsNull(oauthToken.getClientId(), oauthToken.getClientSecret())) {
            String accessToken = this.getData(nextRecord[5]);
            if (accessToken != null && accessToken.length() > 0 && oauthToken.getAccessToken().length() > 0 && oauthToken.getAccessToken().equals(accessToken)) {
                isRowPresent = Boolean.TRUE;
            }
        } else if ((oauthToken.getRefreshToken() != null || oauthToken.getGrantToken() != null) && oauthToken.getClientId() != null && oauthToken.getClientSecret() != null) {
            String grantToken = this.getData(nextRecord[6]);
            String refreshToken = this.getData(nextRecord[4]);
            if (grantToken != null && grantToken.length() > 0 && oauthToken.getGrantToken() != null && oauthToken.getGrantToken().length() > 0 && oauthToken.getGrantToken().equals(grantToken)) {
                isRowPresent = Boolean.TRUE;
            } else if (refreshToken != null && refreshToken.length() > 0 && oauthToken.getRefreshToken() != null && oauthToken.getRefreshToken().length() > 0 && oauthToken.getRefreshToken().equals(refreshToken)) {
                isRowPresent = Boolean.TRUE;
            }
        }
        return isRowPresent;
    }

    private String getData(String value) {
        return value != null && !value.isEmpty() && value.length() > 0 ? value : null;
    }

    private void setMergeData(OAuthToken oauthToken, String[] nextRecord) throws SDKException {
        String expiresIn;
        String name;
        if (oauthToken.getId() == null) {
            oauthToken.setId(this.getData(nextRecord[0]));
        }
        if (oauthToken.getUserSignature() == null && (name = this.getData(nextRecord[1])) != null) {
            oauthToken.setUserSignature(new UserSignature(name));
        }
        if (oauthToken.getClientId() == null) {
            oauthToken.setClientId(this.getData(nextRecord[2]));
        }
        if (oauthToken.getClientSecret() == null) {
            oauthToken.setClientSecret(this.getData(nextRecord[3]));
        }
        if (oauthToken.getRefreshToken() == null) {
            oauthToken.setRefreshToken(this.getData(nextRecord[4]));
        }
        if (oauthToken.getAccessToken() == null) {
            oauthToken.setAccessToken(this.getData(nextRecord[5]));
        }
        if (oauthToken.getGrantToken() == null) {
            oauthToken.setGrantToken(this.getData(nextRecord[6]));
        }
        if (oauthToken.getExpiresIn() == null && (expiresIn = this.getData(nextRecord[7])) != null) {
            oauthToken.setExpiresIn(String.valueOf(expiresIn));
        }
        if (oauthToken.getRedirectURL() == null) {
            oauthToken.setRedirectURL(this.getData(nextRecord[8]));
        }
        if (oauthToken.getAPIDomain() == null) {
            oauthToken.setAPIDomain(this.getData(nextRecord[9]));
        }
    }

    private String[] setToken(OAuthToken oauthToken) {
        String[] data = new String[]{oauthToken.getId(), oauthToken.getUserSignature() != null ? oauthToken.getUserSignature().getName() : null, oauthToken.getClientId(), oauthToken.getClientSecret(), oauthToken.getRefreshToken(), oauthToken.getAccessToken(), oauthToken.getGrantToken(), oauthToken.getExpiresIn(), oauthToken.getRedirectURL(), oauthToken.getAPIDomain()};
        return data;
    }

    private String generateId(List<String[]> allContents) {
        int maxValue = 0;
        if (allContents.size() > 1) {
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = allContents.get(index);
                if (nextRecord.length <= 1 || nextRecord[0] == null || nextRecord[0].length() <= 0 || maxValue >= Integer.parseInt(nextRecord[0])) continue;
                maxValue = Integer.parseInt(nextRecord[0]);
            }
        }
        return String.valueOf(maxValue + 1);
    }

    public boolean areAllObjectsNull(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }
}

