/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DBStore
implements TokenStore {
    private String userName;
    private String portNumber;
    private String password;
    private String host;
    private String databaseName;
    private String connectionString;
    private String tableName;

    private DBStore(String host, String databaseName, String tableName, String userName, String password, String portNumber) {
        this.host = host;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.userName = userName;
        this.password = password;
        this.portNumber = portNumber;
        this.connectionString = "jdbc:mysql://" + this.host + ":" + this.portNumber + "/" + this.databaseName + "?allowPublicKeyRetrieval=true&useSSL=false";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token findToken(Token token) throws SDKException {
        try {
            OAuthToken oauthToken = (OAuthToken)token;
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(this.tableName);
            String param = null;
            if (oauthToken.getUserSignature() != null) {
                String name = oauthToken.getUserSignature().getName();
                if (name != null && name.length() > 0) {
                    query.append(" WHERE user_name = ?");
                    param = name;
                }
            } else if (oauthToken.getAccessToken() != null && this.areAllObjectsNull(oauthToken.getClientId(), oauthToken.getClientSecret())) {
                query.append(" WHERE access_token = ?");
                param = oauthToken.getAccessToken();
            } else if ((oauthToken.getRefreshToken() != null || oauthToken.getGrantToken() != null) && oauthToken.getClientId() != null && oauthToken.getClientSecret() != null) {
                if (oauthToken.getGrantToken() != null && oauthToken.getGrantToken().length() > 0) {
                    query.append(" WHERE grant_token = ?");
                    param = oauthToken.getGrantToken();
                } else if (oauthToken.getRefreshToken() != null && oauthToken.getRefreshToken().length() > 0) {
                    query.append(" WHERE refresh_token = ?");
                    param = oauthToken.getRefreshToken();
                }
            }
            query.append(" LIMIT 1");
            Class.forName("com.mysql.cj.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 PreparedStatement statement = connection.prepareStatement(query.toString());){
                statement.setObject(1, param);
                try (ResultSet result = statement.executeQuery();){
                    if (!result.next()) {
                        Token token2 = null;
                        return token2;
                    }
                    this.setMergeData(oauthToken, result);
                    return token;
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in DBStore : Given user authentication details not found.", ex);
        }
    }

    @Override
    public void saveToken(Token token) throws SDKException {
        block33: {
            if (!(token instanceof OAuthToken)) {
                return;
            }
            try {
                OAuthToken oauthToken = (OAuthToken)token;
                StringBuilder query = new StringBuilder().append("update ").append(this.tableName).append(" set ");
                String param = null;
                if (oauthToken.getUserSignature() != null) {
                    String name = oauthToken.getUserSignature().getName();
                    if (name != null && name.length() > 0) {
                        query.append(this.setToken(oauthToken)).append(" where user_name = ?");
                        param = name;
                    }
                } else if (oauthToken.getAccessToken() != null && oauthToken.getAccessToken().length() > 0 && this.areAllObjectsNull(oauthToken.getClientId(), oauthToken.getClientSecret())) {
                    query.append(this.setToken(oauthToken)).append(" where access_token = ?");
                    param = oauthToken.getAccessToken();
                } else if ((oauthToken.getRefreshToken() != null && oauthToken.getRefreshToken().length() > 0 || oauthToken.getGrantToken() != null && oauthToken.getGrantToken().length() > 0) && oauthToken.getClientId() != null && oauthToken.getClientSecret() != null) {
                    if (oauthToken.getGrantToken() != null && oauthToken.getGrantToken().length() > 0) {
                        query.append(this.setToken(oauthToken)).append(" where grant_token = ?");
                        param = oauthToken.getGrantToken();
                    } else if (oauthToken.getRefreshToken() != null && oauthToken.getRefreshToken().length() > 0) {
                        query.append(this.setToken(oauthToken)).append(" where refresh_token = ?");
                        param = oauthToken.getRefreshToken();
                    }
                }
                query.append(" limit 1");
                Class.forName("com.mysql.cj.jdbc.Driver");
                try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                    int rowaffected = 0;
                    try (PreparedStatement statement = connection.prepareStatement(query.toString());){
                        statement.setObject(1, param);
                        rowaffected = statement.executeUpdate();
                    }
                    if (rowaffected != 0) break block33;
                    if ((oauthToken.getId() != null || oauthToken.getUserSignature() != null) && oauthToken.getRefreshToken() == null && oauthToken.getGrantToken() == null && oauthToken.getAccessToken() == null) {
                        throw new SDKException("TOKEN_STORE", "Exception in DBStore : Given user authentication details not found.");
                    }
                    if (oauthToken.getId() == null) {
                        String newId = String.valueOf(this.generateId());
                        oauthToken.setId(newId);
                    }
                    statement = connection.prepareStatement("insert into " + this.tableName + "(id,user_name,client_id,client_secret,refresh_token,access_token,grant_token,expiry_time,redirect_url,api_domain) values(?,?,?,?,?,?,?,?,?,?) on duplicate key update user_name=values(user_name),client_id=values(client_id),client_secret=values(client_secret),refresh_token=values(refresh_token),access_token=values(access_token),grant_token=values(grant_token),expiry_time=values(expiry_time),redirect_url=values(redirect_url),api_domain=values(api_domain);");
                    try {
                        statement.setString(1, oauthToken.getId());
                        statement.setString(2, oauthToken.getUserSignature() != null ? oauthToken.getUserSignature().getName() : null);
                        statement.setString(3, oauthToken.getClientId());
                        statement.setString(4, oauthToken.getClientSecret());
                        statement.setString(5, oauthToken.getRefreshToken());
                        statement.setString(6, oauthToken.getAccessToken());
                        statement.setString(7, oauthToken.getGrantToken());
                        statement.setString(8, oauthToken.getExpiresIn());
                        statement.setString(9, oauthToken.getRedirectURL());
                        statement.setString(10, oauthToken.getAPIDomain());
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new SDKException("TOKEN_STORE", "Exception in saveToken - DBStore : ", ex);
            }
        }
    }

    @Override
    public void deleteToken(String id) throws SDKException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE id = ?");){
                statement.setString(1, id);
                statement.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteToken - DBStore : ", ex);
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 Statement statement = connection.createStatement();){
                String query = "select * from " + this.tableName + ";";
                try (ResultSet result = statement.executeQuery(query);){
                    while (result.next()) {
                        OAuthToken oauthToken = new OAuthToken();
                        this.setMergeData(oauthToken, result);
                        tokens.add(oauthToken);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - DBStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                String query = "delete from " + this.tableName;
                try (PreparedStatement statement = connection.prepareStatement(query);){
                    statement.executeUpdate();
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - DBStore : ", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Token findTokenById(String id) throws SDKException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setMergeData(OAuthToken oauthToken, ResultSet result) throws SQLException, SDKException {
        String expiresIn;
        String name;
        if (oauthToken.getId() == null) {
            oauthToken.setId(result.getString(1));
        }
        if (oauthToken.getUserSignature() == null && (name = result.getString(2)) != null) {
            oauthToken.setUserSignature(new UserSignature(name));
        }
        if (oauthToken.getClientId() == null) {
            oauthToken.setClientId(result.getString(3));
        }
        if (oauthToken.getClientSecret() == null) {
            oauthToken.setClientSecret(result.getString(4));
        }
        if (oauthToken.getRefreshToken() == null) {
            oauthToken.setRefreshToken(result.getString(5));
        }
        if (oauthToken.getAccessToken() == null) {
            oauthToken.setAccessToken(result.getString(6));
        }
        if (oauthToken.getGrantToken() == null) {
            oauthToken.setGrantToken(result.getString(7));
        }
        if (oauthToken.getExpiresIn() == null && (expiresIn = result.getString(8)) != null) {
            oauthToken.setExpiresIn(String.valueOf(expiresIn));
        }
        if (oauthToken.getRedirectURL() == null) {
            oauthToken.setRedirectURL(result.getString(9));
        }
        if (oauthToken.getAPIDomain() == null) {
            oauthToken.setAPIDomain(result.getString(10));
        }
    }

    private String setToken(OAuthToken oauthToken) {
        String name;
        ArrayList<String> query = new ArrayList<String>();
        if (oauthToken.getUserSignature() != null && (name = oauthToken.getUserSignature().getName()) != null && name.length() > 0) {
            query.add(this.setTokenInfo("user_name", name));
        }
        if (oauthToken.getClientId() != null) {
            query.add(this.setTokenInfo("client_id", oauthToken.getClientId()));
        }
        if (oauthToken.getClientSecret() != null) {
            query.add(this.setTokenInfo("client_secret", oauthToken.getClientSecret()));
        }
        if (oauthToken.getRefreshToken() != null) {
            query.add(this.setTokenInfo("refresh_token", oauthToken.getRefreshToken()));
        }
        if (oauthToken.getAccessToken() != null) {
            query.add(this.setTokenInfo("access_token", oauthToken.getAccessToken()));
        }
        if (oauthToken.getGrantToken() != null) {
            query.add(this.setTokenInfo("grant_token", oauthToken.getGrantToken()));
        }
        if (oauthToken.getExpiresIn() != null) {
            query.add(this.setTokenInfo("expiry_time", oauthToken.getExpiresIn()));
        }
        if (oauthToken.getRedirectURL() != null) {
            query.add(this.setTokenInfo("redirect_url", oauthToken.getRedirectURL()));
        }
        if (oauthToken.getAPIDomain() != null) {
            query.add(this.setTokenInfo("api_domain", oauthToken.getAPIDomain()));
        }
        return String.join((CharSequence)",", query);
    }

    private String setTokenInfo(String key, String value) {
        return key + "='" + value + "'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int generateId() throws SDKException {
        int id = 0;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 Statement statement = connection.createStatement();){
                String query = "select coalesce(max(`id`), 0) as id from " + this.tableName + ";";
                try (ResultSet result = statement.executeQuery(query);){
                    if (!result.next()) {
                        int n = id;
                        return n;
                    }
                    do {
                        Integer max;
                        if ((max = Integer.valueOf(result.getInt(1))) == null) continue;
                        int n = max + 1;
                        return n;
                    } while (result.next());
                    return id;
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in generateId() - DBStore", ex);
        }
    }

    public boolean areAllObjectsNull(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String userName = "root";
        private String portNumber = "3306";
        private String password = "";
        private String host = "localhost";
        private String databaseName = "zohooauth";
        private String tableName = "oauthtoken";

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder portNumber(String portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DBStore build() {
            return new DBStore(this.host, this.databaseName, this.tableName, this.userName, this.password, this.portNumber);
        }
    }
}

