/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIHTTPConnector;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Utility;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthToken
implements Token {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private String clientID;
    private String clientSecret;
    private String redirectURL;
    private String grantToken;
    private String refreshToken;
    private String accessToken;
    private String expiresIn;
    private UserSignature userSignature;
    private String id;
    private String apiDomain;
    private boolean findUser;

    public OAuthToken() {
    }

    private OAuthToken(String clientID, String clientSecret, String grantToken, String refreshToken, String redirectURL, String id, String accessToken, UserSignature userSignature, boolean findUser) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.grantToken = grantToken;
        this.refreshToken = refreshToken;
        this.redirectURL = redirectURL;
        this.accessToken = accessToken;
        this.id = id;
        this.userSignature = userSignature;
        this.findUser = findUser;
    }

    public String getClientId() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getGrantToken() {
        return this.grantToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setClientId(String clientID) {
        this.clientID = clientID;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setGrantToken(String grantToken) {
        this.grantToken = grantToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public UserSignature getUserSignature() {
        return this.userSignature;
    }

    public void setUserSignature(UserSignature userSignature) {
        this.userSignature = userSignature;
    }

    public String getAPIDomain() {
        return this.apiDomain;
    }

    public void setAPIDomain(String apiDomain) {
        this.apiDomain = apiDomain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void generateToken() throws SDKException {
        this.getToken();
    }

    public String getToken() throws SDKException {
        DataCenter.Environment environment;
        Initializer initializer = Initializer.getInitializer();
        TokenStore store = initializer.getStore();
        OAuthToken oauthToken = null;
        if (this.getId() != null) {
            oauthToken = (OAuthToken)store.findTokenById(this.getId());
            this.mergeObjects(this, oauthToken);
            oauthToken.findUser = this.findUser;
        } else {
            oauthToken = (OAuthToken)store.findToken(this);
        }
        if (oauthToken == null) {
            if (this.getUserSignature() != null) {
                this.checkTokenDetails();
            }
            oauthToken = this;
        }
        if (oauthToken.getAPIDomain() == null || oauthToken.getAPIDomain().length() <= 0) {
            if (initializer.getEnvironment() == null) {
                throw new SDKException("ENVIRONMENT_ERROR", "Environment MUST NOT be null.".concat(" : "));
            }
            oauthToken.setAPIDomain(initializer.getEnvironment().getUrl());
        }
        if ((environment = DataCenter.get(oauthToken.getAPIDomain())) != null) {
            Class<?> cl = initializer.getClass();
            try {
                Field member = cl.getDeclaredField("environment");
                member.setAccessible(true);
                member.set(initializer, environment);
            }
            catch (Exception e) {
                throw new SDKException("Exception in set the api environment.".concat(" : "), e);
            }
        } else if (initializer.getEnvironment() == null) {
            throw new SDKException("ENVIRONMENT_ERROR", "Environment MUST NOT be null.".concat(" : "));
        }
        String url = initializer.getEnvironment().getAccountsUrl();
        boolean save = false;
        if (oauthToken.getAccessToken() == null || oauthToken.getAccessToken().length() == 0) {
            if (oauthToken.getRefreshToken() != null && oauthToken.getRefreshToken().length() > 0) {
                LOGGER.log(Level.INFO, "Access token can be generated by refresh token");
                oauthToken.refreshAccessToken(oauthToken, url);
            } else {
                LOGGER.log(Level.INFO, "Access token can be generated by grant token.");
                oauthToken.generateAccessToken(oauthToken, url);
            }
            save = true;
        } else if (oauthToken.getExpiresIn() != null && oauthToken.getExpiresIn().length() > 0 && Long.valueOf(oauthToken.getExpiresIn()) - System.currentTimeMillis() < 5000L) {
            LOGGER.log(Level.INFO, "Access Token has expired. Hence refreshing.");
            oauthToken.refreshAccessToken(oauthToken, url);
            save = true;
        } else if (oauthToken.getExpiresIn() == null && oauthToken.getAccessToken() != null && oauthToken.getId() == null) {
            save = true;
        }
        if (save) {
            try {
                if (oauthToken.getUserSignature() == null && oauthToken.findUser) {
                    try {
                        String userName = new Utility().getUserName(oauthToken.getAccessToken());
                        if (userName != null) {
                            oauthToken.setUserSignature(new UserSignature(userName));
                        }
                    }
                    catch (SDKException ex) {
                        LOGGER.log(Level.SEVERE, "API_EXCEPTION", ex);
                    }
                }
                store.saveToken(oauthToken);
            }
            catch (Exception ex) {
                throw new SDKException("Exception in saving tokens : ", ex);
            }
        }
        return oauthToken.getAccessToken();
    }

    private Boolean checkTokenDetails() throws SDKException {
        if (OAuthToken.areAllObjectsNull(this.grantToken, this.refreshToken)) {
            throw new SDKException("MANDATORY VALUE ERROR", "Exception in getToken() - OAuthToken : Given user_name token details not found, Please give required item".concat(" - ").concat(String.join((CharSequence)", ", Constants.OAUTH_MANDATORY_KEYS2)));
        }
        return true;
    }

    @Override
    public synchronized void authenticate(APIHTTPConnector urlConnection) throws SDKException {
        if (!urlConnection.getHeaders().containsKey("Authorization")) {
            urlConnection.addHeader("Authorization", "Zoho-oauthtoken ".concat(this.getToken()));
        }
    }

    private String getResponseFromServer(HashMap<String, String> requestParams, String url) throws SDKException {
        try {
            String USER_AGENT = "Mozilla/5.0";
            CloseableHttpClient client = this.getHttpClient();
            HttpPost post = new HttpPost(url);
            post.setHeader("user-agent", (Object)"Mozilla/5.0");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            if (requestParams != null && requestParams.size() > 0) {
                for (String key : requestParams.keySet()) {
                    urlParameters.add(new BasicNameValuePair(key, requestParams.get(key)));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8));
            LOGGER.log(Level.INFO, this.toString(url));
            BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
            return (String)client.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)handler);
        }
        catch (Exception ex) {
            throw new SDKException(ex);
        }
    }

    public String toString(String url) {
        StringBuilder requestStringBuilder = new StringBuilder();
        requestStringBuilder.append("POST - ");
        requestStringBuilder.append("URL").append(" = ").append(url.toString()).append(".");
        return requestStringBuilder.toString();
    }

    private CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException {
        return HttpClients.createSystem();
    }

    private OAuthToken refreshAccessToken(OAuthToken oauthToken, String url) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", oauthToken.getClientId());
        requestParams.put("client_secret", oauthToken.getClientSecret());
        requestParams.put("grant_type", "refresh_token");
        requestParams.put("refresh_token", oauthToken.getRefreshToken());
        try {
            this.parseResponse(oauthToken, this.getResponseFromServer(requestParams, url));
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in refresh the Access token : ", ex);
        }
        return oauthToken;
    }

    private OAuthToken generateAccessToken(OAuthToken oauthToken, String url) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", oauthToken.getClientId());
        requestParams.put("client_secret", oauthToken.getClientSecret());
        if (oauthToken.getRedirectURL() != null) {
            requestParams.put("redirect_uri", oauthToken.getRedirectURL());
        }
        requestParams.put("grant_type", "authorization_code");
        requestParams.put("code", oauthToken.getGrantToken());
        try {
            this.parseResponse(oauthToken, this.getResponseFromServer(requestParams, url));
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in generate Access token method: ", ex);
        }
        return oauthToken;
    }

    private Boolean revokeRefreshToken(String refreshToken, String url) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("token", refreshToken);
        String response = "";
        try {
            response = this.getResponseFromServer(requestParams, url);
            JSONObject responseJSON = new JSONObject(response);
            if (responseJSON != null && responseJSON.has("status") && responseJSON.getString("status").equals("success")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (JSONException ex) {
            throw new SDKException("Exception in parsing token response".concat(" : ").concat(response), (Exception)((Object)ex));
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception while revoke the refresh token.", ex);
        }
    }

    private void parseResponse(OAuthToken oauthToken, String response) throws Exception {
        try {
            Initializer initializer = Initializer.getInitializer();
            SDKConfig sdkConfig = initializer.getSDKConfig();
            JSONObject responseJSON = new JSONObject(response);
            if (!responseJSON.has("access_token")) {
                throw new SDKException("INVALID TOKEN ERROR", responseJSON.has("error") ? responseJSON.getString("error") : "ACCESS TOKEN IS NOT PRESENT IN RESPONSE");
            }
            oauthToken.setAccessToken(responseJSON.getString("access_token"));
            oauthToken.setExpiresIn(String.valueOf(this.getTokenExpiresIn(responseJSON)));
            if (responseJSON.has("refresh_token")) {
                oauthToken.setRefreshToken(responseJSON.getString("refresh_token"));
            }
            if (sdkConfig.applyAPIDomainUpdate() && responseJSON.has("api_domain")) {
                oauthToken.setAPIDomain(responseJSON.getString("api_domain"));
            }
        }
        catch (JSONException ex) {
            throw new SDKException("Exception in parsing token response".concat(" : ").concat(response), (Exception)((Object)ex));
        }
    }

    private Long getTokenExpiresIn(JSONObject response) {
        return System.currentTimeMillis() + (response.has("expires_in_sec") ? response.getLong("expires_in") : (long)(response.getInt("expires_in") * 1000));
    }

    @Override
    public void remove() throws SDKException {
        try {
            if (Initializer.getInitializer() == null) {
                throw new SDKException("SDK UNINITIALIZED ERROR", "SDK is UnInitialized");
            }
            Initializer.getInitializer().getStore().deleteToken(this.getId());
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException(ex);
        }
    }

    @Override
    public Boolean revoke(String id) throws SDKException {
        try {
            if (Initializer.getInitializer() == null) {
                throw new SDKException("SDK UNINITIALIZED ERROR", "SDK is UnInitialized");
            }
            Initializer initializer = Initializer.getInitializer();
            TokenStore store = initializer.getStore();
            String url = initializer.getEnvironment().getAccountsUrl();
            Boolean isRevoke = Boolean.FALSE;
            OAuthToken oauthToken = new OAuthToken();
            oauthToken.setId(id);
            store.findToken(oauthToken);
            if (oauthToken != null && oauthToken.getRefreshToken() != null) {
                isRevoke = this.revokeRefreshToken(oauthToken.getRefreshToken(), url.concat("/revoke"));
                LOGGER.log(Level.INFO, new StringBuffer().append("id").append(" : ").append(id).append(" Refresh token revoked successfully.").toString());
            } else {
                LOGGER.log(Level.WARNING, new StringBuffer().append("id").append(" : ").append(id).append(" No tokens exist for the given user-id.").toString());
            }
            return isRevoke;
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException(ex);
        }
    }

    public <T> void mergeObjects(T first, T second) throws SDKException {
        try {
            Field[] fields;
            Class<?> clas = first.getClass();
            for (Field field : fields = clas.getDeclaredFields()) {
                if (!Constants.OAUTH_TOKEN_FIELDS.contains(field.getName())) continue;
                field.setAccessible(true);
                Object value1 = field.get(first);
                Object value2 = field.get(second);
                Object value = value1 != null ? value1 : value2;
                field.set(first, value);
            }
        }
        catch (Exception ex) {
            throw new SDKException("MERGE_OBJECT", ex);
        }
    }

    public static boolean areAllObjectsNull(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String clientID;
        private String clientSecret;
        private String redirectURL;
        private String refreshToken;
        private String grantToken;
        private String accessToken;
        private String id;
        private UserSignature userSignature;
        private boolean findUser = true;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder clientID(String clientID) throws SDKException {
            Utility.assertNotNull(clientID, "TOKEN ERROR", "ClientID MUST NOT be null");
            this.clientID = clientID;
            return this;
        }

        public Builder clientSecret(String clientSecret) throws SDKException {
            Utility.assertNotNull(clientSecret, "TOKEN ERROR", "ClientSecret MUST NOT be null");
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder userSignature(UserSignature userSignature) {
            this.userSignature = userSignature;
            return this;
        }

        public Builder findUser(boolean findUser) {
            this.findUser = findUser;
            return this;
        }

        public OAuthToken build() throws SDKException {
            if (OAuthToken.areAllObjectsNull(this.grantToken, this.refreshToken, this.id, this.accessToken, this.userSignature)) {
                throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :".concat(" - ").concat(String.join((CharSequence)", ", Constants.OAUTH_MANDATORY_KEYS)));
            }
            if (!OAuthToken.areAllObjectsNull(this.grantToken, this.refreshToken)) {
                if (OAuthToken.areAllObjectsNull(this.clientID, this.clientSecret)) {
                    throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :".concat(" - ").concat(String.join((CharSequence)", ", Constants.OAUTH_MANDATORY_KEYS1)));
                }
                Utility.assertNotNull(this.clientID, "MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :".concat(" - ").concat("client_id"));
                Utility.assertNotNull(this.clientSecret, "MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :".concat(" - ").concat("client_secret"));
            }
            return new OAuthToken(this.clientID, this.clientSecret, this.grantToken, this.refreshToken, this.redirectURL, this.id, this.accessToken, this.userSignature, this.findUser);
        }
    }
}

